/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.Scalable;
import dr.math.MathUtils;

public class UpDownOperator
extends AbstractAdaptableOperator {
    private Scalable[] upParameter = null;
    private Scalable[] downParameter = null;
    private double scaleFactor;

    public UpDownOperator(Scalable[] scalableArray, Scalable[] scalableArray2, double d, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.setWeight(d2);
        this.upParameter = scalableArray;
        this.downParameter = scalableArray2;
        this.scaleFactor = d;
    }

    public final double getScaleFactor() {
        return this.scaleFactor;
    }

    public final void setScaleFactor(double d) {
        if (!(d > 0.0) || !(d < 1.0)) {
            throw new IllegalArgumentException("scale must be between 0 and 1");
        }
        this.scaleFactor = d;
    }

    @Override
    public final double doOperation() {
        double d = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        int n = 0;
        int n2 = 0;
        if (this.upParameter != null) {
            for (Scalable scalable : this.upParameter) {
                n += scalable.scale(d, -1, false);
            }
            for (Scalable scalable : this.upParameter) {
                if (scalable.testBounds()) continue;
                return Double.NEGATIVE_INFINITY;
            }
        }
        if (this.downParameter != null) {
            for (Scalable scalable : this.downParameter) {
                n2 += scalable.scale(1.0 / d, -1, false);
            }
            for (Scalable scalable : this.downParameter) {
                if (scalable.testBounds()) continue;
                return Double.NEGATIVE_INFINITY;
            }
        }
        return (double)(n - n2 - 2) * Math.log(d);
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    @Override
    public final String getOperatorName() {
        String string = "";
        if (this.upParameter != null) {
            string = "up:";
            for (Scalable scalable : this.upParameter) {
                string = string + scalable.getName() + " ";
            }
        }
        if (this.downParameter != null) {
            string = string + "down:";
            for (Scalable scalable : this.downParameter) {
                string = string + scalable.getName() + " ";
            }
        }
        return string;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0) / Math.log(10.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.pow(10.0, d) + 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }
}

