/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.algo;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.BitSet;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.tools.ArrayUtils;

public class AlgoAllDiffAC {
    int n;
    int n2;
    DirectedGraph digraph;
    int[] matching;
    int[] nodeSCC;
    BitSet free;
    StrongConnectivityFinder SCCfinder;
    private final int[] father;
    private final BitSet in;
    TIntIntHashMap map;
    int[] fifo;
    TIntIntHashMap rmap;
    IntIterableRangeSet set;
    protected IntVar[] vars;
    Propagator<IntVar> aCause;
    int[] order;
    ArraySort<?> sorter;

    public AlgoAllDiffAC(IntVar[] variables, Propagator<IntVar> cause) {
        this.vars = variables;
        this.aCause = cause;
        this.n = this.vars.length;
        this.matching = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.matching[i] = -1;
        }
        this.map = new TIntIntHashMap();
        this.rmap = new TIntIntHashMap();
        int idx = this.n;
        for (int i = 0; i < this.n; ++i) {
            IntVar v = this.vars[i];
            int ub = v.getUB();
            int j = v.getLB();
            while (j <= ub) {
                if (!this.map.containsKey(j)) {
                    this.map.put(j, idx);
                    this.rmap.put(idx, j);
                    ++idx;
                }
                j = v.nextValue(j);
            }
        }
        this.n2 = idx;
        this.fifo = new int[this.n2];
        this.makeDigraph();
        this.free = new BitSet(this.n2);
        this.father = new int[this.n2];
        this.in = new BitSet(this.n2);
        this.SCCfinder = new StrongConnectivityFinder(this.digraph);
        this.order = ArrayUtils.array(0, this.n - 1);
        if (this.aCause.getModel().getSolver().isLCG()) {
            this.set = new IntIterableRangeSet();
            this.sorter = new ArraySort(this.n, false, true);
        }
    }

    protected void makeDigraph() {
        this.digraph = new DirectedGraph(this.n2 + 1, SetType.BITSET, false);
    }

    public boolean propagate() throws ContradictionException {
        this.findMaximumMatching();
        return this.filter();
    }

    private void findMaximumMatching() throws ContradictionException {
        int i;
        for (int i2 = 0; i2 < this.n2; ++i2) {
            this.digraph.getSuccessorsOf(i2).clear();
            this.digraph.getPredecessorsOf(i2).clear();
        }
        this.free.set(0, this.n2);
        for (i = 0; i < this.n; ++i) {
            IntVar v = this.vars[i];
            int ub = v.getUB();
            int mate = this.matching[i];
            int k = v.getLB();
            while (k <= ub) {
                int j = this.map.get(k);
                if (mate == j) {
                    assert (this.free.get(i) && this.free.get(j));
                    this.digraph.addEdge(j, i);
                    this.free.clear(i);
                    this.free.clear(j);
                } else {
                    this.digraph.addEdge(i, j);
                }
                k = v.nextValue(k);
            }
        }
        i = this.free.nextSetBit(0);
        while (i >= 0 && i < this.n) {
            this.tryToMatch(i);
            i = this.free.nextSetBit(i + 1);
        }
        for (i = 0; i < this.n; ++i) {
            this.matching[i] = this.digraph.getPredecessorsOf(i).isEmpty() ? -1 : this.digraph.getPredecessorsOf(i).iterator().next();
        }
    }

    private void tryToMatch(int i) throws ContradictionException {
        int mate = this.augmentPath_BFS(i);
        if (mate != -1) {
            this.free.clear(mate);
            this.free.clear(i);
            int tmp = mate;
            while (tmp != i) {
                this.digraph.removeEdge(this.father[tmp], tmp);
                this.digraph.addEdge(tmp, this.father[tmp]);
                tmp = this.father[tmp];
            }
        } else {
            Reason reason = Reason.undef();
            if (this.aCause.lcg()) {
                this.set.clear();
                this.in.set(i);
                int nvars = 0;
                int l = this.in.nextSetBit(0);
                while (l > -1) {
                    if (l < this.n) {
                        ++nvars;
                    } else {
                        this.set.add(this.rmap.get(l));
                    }
                    l = this.in.nextSetBit(l + 1);
                }
                int[] ps = new int[1 + nvars * (2 + (this.set.max() + 1 - this.set.min()) - this.set.size())];
                int m = 1;
                int l2 = this.in.nextSetBit(0);
                while (l2 > -1 && l2 < this.n) {
                    ps[m++] = MiniSat.neg(this.vars[l2].getLit(this.set.min(), 2));
                    int w = this.set.nextValueOut(this.set.min());
                    while (w < this.set.max()) {
                        ps[m++] = MiniSat.neg(this.vars[l2].getLit(w, 0));
                        w = this.set.nextValueOut(w);
                    }
                    ps[m++] = MiniSat.neg(this.vars[l2].getLit(this.set.max(), 3));
                    l2 = this.in.nextSetBit(l2 + 1);
                }
                assert (m == ps.length);
                reason = Reason.r(ps);
            }
            this.aCause.fails(reason);
        }
    }

    private int augmentPath_BFS(int root) {
        this.in.clear();
        int indexFirst = 0;
        int indexLast = 0;
        this.fifo[indexLast++] = root;
        while (indexFirst != indexLast) {
            int x = this.fifo[indexFirst++];
            ISetIterator succs = this.digraph.getSuccessorsOf(x).iterator();
            while (succs.hasNext()) {
                int y = succs.nextInt();
                if (this.in.get(y)) continue;
                this.father[y] = x;
                this.fifo[indexLast++] = y;
                this.in.set(y);
                if (!this.free.get(y)) continue;
                return y;
            }
        }
        return -1;
    }

    void buildSCC() {
        if (this.n2 > this.n * 2) {
            this.digraph.removeNode(this.n2);
            this.digraph.addNode(this.n2);
            for (int i = this.n; i < this.n2; ++i) {
                if (this.free.get(i)) {
                    this.digraph.addEdge(i, this.n2);
                    continue;
                }
                this.digraph.addEdge(this.n2, i);
            }
        }
        this.SCCfinder.findAllSCC();
        this.nodeSCC = this.SCCfinder.getNodesSCC();
        this.digraph.removeNode(this.n2);
    }

    void distinguish() {
    }

    boolean filterVar(int i) throws ContradictionException {
        boolean filter = false;
        IntVar v = this.vars[i];
        int ub = v.getUB();
        int k = v.getLB();
        while (k <= ub) {
            int j = this.map.get(k);
            filter |= this.filterVar(i, j, v, k);
            k = v.nextValue(k);
        }
        return filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean filterVar(int i, int j, IntVar v, int k) throws ContradictionException {
        if (this.nodeSCC[i] == this.nodeSCC[j]) return false;
        if (this.matching[i] == j) {
            if (v.getModel().getSolver().isLCG()) return false;
            return v.instantiateTo(k, (ICause)this.aCause);
        }
        Reason reason = Reason.undef();
        if (v.getModel().getSolver().isLCG()) {
            int nvars = 0;
            this.set.clear();
            this.set.add(this.rmap.get(j));
            int l = this.SCCfinder.getSCCFirstNode(this.nodeSCC[j]);
            while (l > -1) {
                if (l < this.n) {
                    ++nvars;
                } else {
                    int val = this.rmap.get(l);
                    this.set.add(val);
                }
                l = this.SCCfinder.getNextNode(l);
            }
            if (this.set.size() == 1) {
                int vidx = this.digraph.getSuccessorsOf(j).min();
                if (!this.vars[vidx].isInstantiated()) return false;
                assert (this.vars[vidx].isInstantiatedTo(k));
                reason = Reason.r(this.vars[vidx].getValLit());
            } else {
                int[] ps = new int[1 + nvars * (2 + (this.set.max() + 1 - this.set.min()) - this.set.size())];
                int m = 1;
                int l2 = this.SCCfinder.getSCCFirstNode(this.nodeSCC[j]);
                while (l2 > -1) {
                    if (l2 < this.n) {
                        ps[m++] = MiniSat.neg(this.vars[l2].getLit(this.set.min(), 2));
                        int w = this.set.nextValueOut(this.set.min());
                        while (w < this.set.max()) {
                            ps[m++] = MiniSat.neg(this.vars[l2].getLit(w, 0));
                            w = this.set.nextValueOut(w);
                        }
                        ps[m++] = MiniSat.neg(this.vars[l2].getLit(this.set.max(), 3));
                    }
                    l2 = this.SCCfinder.getNextNode(l2);
                }
                assert (m == ps.length);
                reason = Reason.r(ps);
            }
        }
        if (!v.removeValue(k, this.aCause, reason)) return false;
        this.digraph.removeEdge(i, j);
        return true;
    }

    private boolean filter() throws ContradictionException {
        int i;
        boolean filter = false;
        this.distinguish();
        this.buildSCC();
        if (this.aCause.getModel().getSolver().isLCG()) {
            this.sorter.sort(this.order, this.n, (k, l) -> this.nodeSCC[k] - this.nodeSCC[l]);
        }
        for (i = 0; i < this.n; ++i) {
            filter |= this.filterVar(this.order[i]);
        }
        for (i = 0; i < this.n; ++i) {
            int j;
            IntVar v = this.vars[i];
            if (v.hasEnumeratedDomain()) continue;
            assert (!v.getModel().getSolver().isLCG()) : "not implemented yet for LCG";
            int ub = v.getUB();
            for (int k2 = v.getLB(); k2 <= ub; ++k2) {
                j = this.map.get(k2);
                if (this.digraph.containsEdge(i, j) || this.digraph.containsEdge(j, i)) continue;
                filter |= v.removeValue(k2, (ICause)this.aCause);
            }
            int lb = v.getLB();
            for (int k3 = v.getUB(); k3 >= lb; --k3) {
                j = this.map.get(k3);
                if (this.digraph.containsEdge(i, j) || this.digraph.containsEdge(j, i)) continue;
                filter |= v.removeValue(k3, (ICause)this.aCause);
            }
        }
        return filter;
    }
}

