/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.element;

import java.util.Random;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

@Explained
public class PropElementV_fast
extends Propagator<IntVar> {
    private static final int THRESHOLD = 100;
    private final IntVar var;
    private final IntVar index;
    private boolean fast;
    private final Random rd;
    private int calls;
    private int success;
    private boolean rem;

    public PropElementV_fast(IntVar value, IntVar[] values, IntVar index) {
        super((Variable[])ArrayUtils.append({value, index}, values), (Priority)PropagatorPriority.LINEAR, false);
        this.var = ((IntVar[])this.vars)[0];
        this.index = ((IntVar[])this.vars)[1];
        this.fast = true;
        this.rd = new Random(((IntVar[])this.vars)[0].getModel().getSeed());
        this.success = 1;
        this.calls = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate(int evtmask) throws ContradictionException {
        double p = (double)this.success * 1.0 / ((double)this.calls * 1.0);
        this.fast = (double)this.rd.nextFloat() < p;
        this.rem = false;
        try {
            this.index.updateLowerBound(0, this, Reason.undef());
            this.index.updateUpperBound(((IntVar[])this.vars).length - 3, this, Reason.undef());
            this.filter();
        }
        finally {
            ++this.calls;
            if (this.rem) {
                ++this.success;
            }
        }
    }

    private void filter() throws ContradictionException {
        IntVar v;
        boolean filter;
        do {
            int m;
            filter = false;
            int lb = this.index.getLB();
            int ub = this.index.getUB();
            int min = 0x3FFFFFFF;
            int max = -1073741824;
            int i = lb;
            int j = ub;
            while (i <= j) {
                Reason r;
                if (this.disjoint(this.var, ((IntVar[])this.vars)[2 + i])) {
                    r = Reason.undef();
                    if (this.lcg()) {
                        r = Propagator.reason(null, this.var, ((IntVar[])this.vars)[2 + i]);
                    }
                    filter |= this.index.removeValue(i, this, r);
                } else {
                    min = Math.min(min, ((IntVar[])this.vars)[2 + i].getLB());
                    max = Math.max(max, ((IntVar[])this.vars)[2 + i].getUB());
                }
                if (i == j) break;
                if (this.disjoint(this.var, ((IntVar[])this.vars)[2 + j])) {
                    r = Reason.undef();
                    if (this.lcg()) {
                        r = Propagator.reason(null, this.var, ((IntVar[])this.vars)[2 + j]);
                    }
                    filter |= this.index.removeValue(j, this, r);
                } else {
                    min = Math.min(min, ((IntVar[])this.vars)[2 + j].getLB());
                    max = Math.max(max, ((IntVar[])this.vars)[2 + j].getUB());
                }
                i = this.index.nextValue(i);
                j = this.index.previousValue(j);
            }
            Reason r = Reason.undef();
            if (this.lcg() && this.var.getLB() < min) {
                int[] ps = new int[ub + 4 - lb];
                ps[1] = this.index.getMinLit();
                ps[2] = this.index.getMaxLit();
                int i2 = lb;
                m = 3;
                while (i2 <= ub) {
                    ps[m] = this.index.contains(i2) ? ((IntVar[])this.vars)[2 + i2].getMinLit() : this.index.getEQLit(i2);
                    ++i2;
                    ++m;
                }
                r = Reason.r(ps);
            }
            filter |= this.var.updateLowerBound(min, this, r);
            r = Reason.undef();
            if (this.lcg() && this.var.getUB() > max) {
                int[] ps = new int[ub + 4 - lb];
                ps[1] = this.index.getMinLit();
                ps[2] = this.index.getMaxLit();
                int i3 = lb;
                m = 3;
                while (i3 <= ub) {
                    ps[m] = this.index.contains(i3) ? ((IntVar[])this.vars)[2 + i3].getMaxLit() : this.index.getEQLit(i3);
                    ++i3;
                    ++m;
                }
                r = Reason.r(ps);
            }
            filter |= this.var.updateUpperBound(max, this, r);
            if (!this.index.isInstantiated()) continue;
            filter |= this.propagateEquality(this.var, ((IntVar[])this.vars)[2 + this.index.getValue()]);
        } while (filter);
        if (this.var.isInstantiated() && this.index.isInstantiated() && (v = ((IntVar[])this.vars)[2 + this.index.getValue()]).isInstantiated() && v.getValue() == this.var.getValue()) {
            this.setPassive();
        }
    }

    private boolean propagateEquality(IntVar a, IntVar b) throws ContradictionException {
        int s = a.getDomainSize() + b.getDomainSize();
        boolean filter = a.updateLowerBound(b.getLB(), this, this.lcg() ? Reason.r(this.index.getValLit(), b.getMinLit()) : Reason.undef());
        filter |= a.updateUpperBound(b.getUB(), this, this.lcg() ? Reason.r(this.index.getValLit(), b.getMaxLit()) : Reason.undef());
        filter |= b.updateLowerBound(a.getLB(), this, this.lcg() ? Reason.r(this.index.getValLit(), a.getMinLit()) : Reason.undef());
        filter |= b.updateUpperBound(a.getUB(), this, this.lcg() ? Reason.r(this.index.getValLit(), a.getMaxLit()) : Reason.undef());
        if (!this.fast || a.getDomainSize() + b.getDomainSize() <= 100) {
            this.rem |= this.filterFrom(a, b);
            this.rem |= this.filterFrom(b, a);
        }
        if (a.getDomainSize() + b.getDomainSize() != s) {
            filter |= this.propagateEquality(a, b);
        }
        return filter;
    }

    private boolean filterFrom(IntVar a, IntVar b) throws ContradictionException {
        boolean filter = false;
        if (a.getDomainSize() != b.getDomainSize()) {
            int lb = a.getLB();
            int ub = a.getUB();
            int i = lb;
            while (i <= ub) {
                if (!b.contains(i)) {
                    filter |= a.removeValue(i, this, this.lcg() ? Reason.r(this.index.getValLit(), b.getEQLit(i)) : Reason.undef());
                }
                i = a.nextValue(i);
            }
        }
        return filter;
    }

    private boolean disjoint(IntVar a, IntVar b) {
        int ua;
        int lb;
        int ub;
        int la = a.getLB();
        if (la > (ub = b.getUB()) || (lb = b.getLB()) > (ua = a.getUB())) {
            return true;
        }
        if (this.fast && a.getDomainSize() + b.getDomainSize() > 100) {
            return false;
        }
        if (a.getDomainSize() <= b.getDomainSize() ? this.intersect(a, la, ua, b, lb, ub) : this.intersect(b, lb, ub, a, la, ua)) {
            return false;
        }
        this.rem = true;
        return true;
    }

    private boolean intersect(IntVar v1, int l1, int u1, IntVar v2, int l2, int u2) {
        int low = Math.max(l1, l2);
        int upp = Math.min(u1, u2);
        int i = v1.nextValue(low - 1);
        while (i <= upp) {
            if (v2.contains(i)) {
                return true;
            }
            i = v1.nextValue(i);
        }
        return false;
    }

    @Override
    public ESat isEntailed() {
        int lb = this.index.getLB();
        int ub = this.index.getUB();
        int min = 0x3FFFFFFF;
        int max = -1073741824;
        int val = this.var.getLB();
        boolean exists = false;
        int i = lb;
        while (i <= ub) {
            int j = 2 + i;
            if (j >= 2 && j < ((IntVar[])this.vars).length) {
                min = Math.min(min, ((IntVar[])this.vars)[j].getLB());
                max = Math.max(max, ((IntVar[])this.vars)[j].getUB());
                exists |= ((IntVar[])this.vars)[j].contains(val);
            }
            i = this.index.nextValue(i);
        }
        if (min > this.var.getUB() || max < this.var.getLB()) {
            return ESat.FALSE;
        }
        if (this.var.isInstantiated() && !exists) {
            return ESat.FALSE;
        }
        if (this.var.isInstantiated() && min == max) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

