/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.BitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class PropLocalConDis
extends Propagator<IntVar> {
    Propagator<IntVar>[][] propagators;
    IStateInt idx;
    final int[] cardinalities;
    TIntObjectHashMap<IntIterableRangeSet> domains;
    BitSet toUnion;

    public PropLocalConDis(IntVar[] vars, Propagator<IntVar>[][] propagators) {
        super((Variable[])vars, (Priority)PropagatorPriority.VERY_SLOW, false);
        this.propagators = propagators;
        this.cardinalities = new int[vars.length];
        this.domains = new TIntObjectHashMap();
        this.toUnion = new BitSet();
        this.idx = this.model.getEnvironment().makeInt(propagators.length - 1);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        block0: do {
            int i;
            for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
                this.cardinalities[i] = ((IntVar[])this.vars)[i].getDomainSize();
                if (this.domains.get(i) == null) continue;
                this.domains.get(i).clear();
            }
            this.toUnion.clear();
            for (i = this.idx.get(); i >= 0; --i) {
                if (this.propagate(this.propagators[i], i)) {
                    int last = this.idx.add(-1) + 1;
                    if (last <= i) continue;
                    Propagator<IntVar>[] tmp = this.propagators[i];
                    this.propagators[i] = this.propagators[last];
                    this.propagators[last] = tmp;
                    continue;
                }
                if (this.toUnion.cardinality() == 0) continue block0;
            }
        } while (this.applyDeductions());
    }

    private boolean applyDeductions() throws ContradictionException {
        boolean change = false;
        int id = this.idx.get();
        if (id < 0) {
            this.fails();
        }
        int p = this.toUnion.nextSetBit(0);
        while (p >= 0) {
            change |= ((IntVar[])this.vars)[p].removeAllValuesBut(this.domains.get(p), this);
            p = this.toUnion.nextSetBit(p + 1);
        }
        if (id == 0) {
            this.setPassive();
            for (p = 0; p < this.propagators[0].length; ++p) {
                assert (this.propagators[0][p].isReifiedAndSilent());
                this.propagators[0][p].setReifiedTrue();
                this.propagators[0][p].propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
                this.model.getSolver().getEngine().onPropagatorExecution(this.propagators[0][p]);
            }
            change = false;
        }
        return change;
    }

    private boolean propagate(Propagator<IntVar>[] props, int cidx) {
        boolean fails = false;
        this.model.getSolver().pushTrail();
        try {
            for (int i = 0; i < props.length; ++i) {
                props[i].setReifiedTrue();
                props[i].propagate(PropagatorEventType.CUSTOM_PROPAGATION.getMask());
            }
            this.readDomains();
        }
        catch (ContradictionException cex) {
            fails = true;
        }
        this.model.getSolver().getEngine().ignoreModifications();
        this.model.getSolver().cancelTrail();
        return fails;
    }

    private void readDomains() {
        if (this.toUnion.cardinality() == 0) {
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                if (this.cardinalities[i] <= ((IntVar[])this.vars)[i].getDomainSize()) continue;
                IntIterableRangeSet rs = this.domains.get(i);
                if (rs == null) {
                    rs = new IntIterableRangeSet();
                    this.domains.put(i, rs);
                }
                rs.copyFrom(((IntVar[])this.vars)[i]);
                this.toUnion.set(i);
            }
        } else {
            int p = this.toUnion.nextSetBit(0);
            while (p >= 0) {
                if (this.cardinalities[p] > ((IntVar[])this.vars)[p].getDomainSize()) {
                    this.domains.get(p).addAll(((IntVar[])this.vars)[p]);
                    if (this.domains.get(p).size() == this.cardinalities[p]) {
                        this.toUnion.clear(p);
                    }
                } else {
                    this.toUnion.clear(p);
                }
                p = this.toUnion.nextSetBit(p + 1);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    @Override
    public String toString() {
        return "ConstructiveDisjunction";
    }
}

