/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution.shrinkage;

import dr.math.MathUtils;
import dr.math.distributions.GammaDistribution;

public class BayesianBridgeRNG {
    private static double drawUnregularizedCoefficient(double d, double d2) {
        double d3 = Math.pow(1.0 / d, d2);
        double d4 = MathUtils.nextDouble();
        double d5 = Math.pow(GammaDistribution.quantile(d4, 1.0 / d2, 1.0 / d3), 1.0 / d2);
        return MathUtils.nextBoolean() ? d5 : -d5;
    }

    private static double drawRegularizedCoefficientBridgeProposal(double d, double d2, double d3) {
        double d4 = Double.NaN;
        boolean bl = false;
        double d5 = 2.0 * d3 * d3;
        while (!bl) {
            double d6 = BayesianBridgeRNG.drawUnregularizedCoefficient(d, d2);
            double d7 = -(d6 * d6) / d5;
            if (!(Math.log(MathUtils.nextDouble()) <= d7)) continue;
            d4 = d6;
            bl = true;
        }
        return d4;
    }

    public static double drawRegularizedCoefficientNormalProposal(double d, double d2, double d3) {
        double d4 = Double.NaN;
        boolean bl = false;
        double d5 = Math.log(d3 * Math.sqrt(Math.PI * 2));
        while (!bl) {
            double d6 = MathUtils.nextGaussian() * d3;
            double d7 = -Math.pow(Math.abs(d6 / d), d2) - d5;
            if (!(Math.log(MathUtils.nextDouble()) <= d7)) continue;
            d4 = d6;
            bl = true;
        }
        return d4;
    }

    public static double drawRegularizedCoefficient(double d, double d2, double d3) {
        double d4 = d > d3 ? BayesianBridgeRNG.drawRegularizedCoefficientNormalProposal(d, d2, d3) : BayesianBridgeRNG.drawRegularizedCoefficientBridgeProposal(d, d2, d3);
        return d4;
    }

    public static double[] nextRandom(double d, double d2, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = BayesianBridgeRNG.drawUnregularizedCoefficient(d, d2);
        }
        return dArray;
    }

    public static double[] nextRandom(double d, double d2, double d3, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = BayesianBridgeRNG.drawRegularizedCoefficient(d, d2, d3);
        }
        return dArray;
    }
}

