/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.Scalable;
import dr.math.MathUtils;

public class MicrosatelliteUpDownOperator
extends AbstractAdaptableOperator {
    private Scalable.Default[] upParameter = null;
    private Scalable.Default[] downParameter = null;
    private double scaleFactor;

    public MicrosatelliteUpDownOperator(Scalable.Default[] defaultArray, Scalable.Default[] defaultArray2, double d, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.setWeight(d2);
        this.upParameter = defaultArray;
        this.downParameter = defaultArray2;
        this.scaleFactor = d;
    }

    public final double getScaleFactor() {
        return this.scaleFactor;
    }

    public final void setScaleFactor(double d) {
        if (!(d > 0.0) || !(d < 1.0)) {
            throw new IllegalArgumentException("scale must be between 0 and 1");
        }
        this.scaleFactor = d;
    }

    @Override
    public final double doOperation() {
        double d = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        int n = 0;
        int n2 = 0;
        if (this.upParameter != null) {
            for (Scalable.Default default_ : this.upParameter) {
                n += default_.scaleAllAndNotify(d, -1, false);
            }
        }
        if (this.downParameter != null) {
            for (Scalable.Default default_ : this.downParameter) {
                n2 += default_.scaleAllAndNotify(1.0 / d, -1, false);
            }
        }
        return (double)(n - n2 - 2) * Math.log(d);
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    @Override
    public final String getOperatorName() {
        String string = "";
        if (this.upParameter != null) {
            string = "up:";
            for (Scalable.Default default_ : this.upParameter) {
                string = string + default_.getName() + " ";
            }
        }
        if (this.downParameter != null) {
            string = string + "down:";
            for (Scalable.Default default_ : this.downParameter) {
                string = string + default_.getName() + " ";
            }
        }
        return string;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0) / Math.log(10.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.pow(10.0, d) + 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    @Override
    public double getMinimumAcceptanceLevel() {
        return 0.05;
    }

    @Override
    public double getMaximumAcceptanceLevel() {
        return 0.3;
    }

    @Override
    public double getMinimumGoodAcceptanceLevel() {
        return 0.1;
    }

    @Override
    public double getMaximumGoodAcceptanceLevel() {
        return 0.2;
    }
}

