/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.NodeRef;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.discrete.NodeHeightProxyParameter;
import dr.evomodel.treedatalikelihood.discrete.NodeHeightToRatiosTransformDelegate;
import dr.inference.model.Bounds;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.Vector;
import java.util.List;

public class NodeHeightToRatiosFullTransformDelegate
extends NodeHeightToRatiosTransformDelegate {
    private double maxTipHeight;
    private final Parameter heightParameter;
    private CompoundParameter rootHeightAndRatios;
    private boolean tipHeightChanged = true;

    public NodeHeightToRatiosFullTransformDelegate(TreeModel treeModel, Parameter parameter, Parameter parameter2, BranchRateModel branchRateModel) {
        super(treeModel, parameter, parameter2, branchRateModel);
        if (treeModel.getInternalNodeCount() != parameter.getDimension()) {
            throw new RuntimeException("Use all internal node (including root) for this transform.");
        }
        this.maxTipHeight = this.getMaxTipHeight();
        this.heightParameter = new HeightParameter(this.tree, new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.rootHeightAndRatios = new CompoundParameter("rootHeightAndRatios", new Parameter[]{this.heightParameter, parameter2});
        this.nodeHeights = new NodeHeightProxyParameter("internalNodeHeights", this.tree, true);
    }

    private double getMaxTipHeight() {
        if (this.tipHeightChanged) {
            double d = 0.0;
            for (int i = 0; i < this.tree.getExternalNodeCount(); ++i) {
                double d2 = this.tree.getNodeHeight(this.tree.getNode(i));
                if (!(d2 > d)) continue;
                d = d2;
            }
            this.maxTipHeight = d;
            this.tipHeightChanged = false;
        }
        return this.maxTipHeight;
    }

    private double getRootHeight(double d) {
        return d + this.getMaxTipHeight();
    }

    @Override
    public double[] transform(double[] dArray) {
        this.setNodeHeights(dArray);
        this.updateRatios();
        return this.setCombinedValues();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        super.handleModelChangedEvent(model, object, n);
        if (model == this.tree) {
            this.tipHeightChanged = true;
        }
    }

    @Override
    String getReport() {
        this.updateRatios();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NodeHeight by inverse ratios: ").append(new Vector(this.inverse(this.setCombinedValues())));
        stringBuilder.append("\n");
        stringBuilder.append("NodeHeights: ").append(new Vector(this.getNodeHeights().getParameterValues()));
        stringBuilder.append("\n\n");
        stringBuilder.append("ratios by transform nodeHeights: ").append(new Vector(this.transform(this.nodeHeights.getParameterValues())));
        stringBuilder.append("\n");
        stringBuilder.append("ratios: ").append(new Vector(this.setCombinedValues()));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    protected int getNodeHeightIndex(NodeRef nodeRef) {
        return this.getNodeHeightGradientIndex(nodeRef);
    }

    @Override
    public double[] updateGradientLogDensity(double[] dArray, double[] dArray2) {
        double[] dArray3 = super.updateGradientLogDensity(dArray, dArray2);
        double[] dArray4 = new double[this.ratios.getDimension() + 1];
        System.arraycopy(dArray3, 0, dArray4, 1, this.ratios.getDimension());
        double[] dArray5 = this.getLogTimeArray();
        dArray4[0] = this.updateHeightParameterGradientUnweightedLogDensity(dArray) - this.updateHeightParameterGradientUnweightedLogDensity(dArray5);
        return dArray4;
    }

    @Override
    public double[] setMaskByHeightDifference(double d) {
        return this.addOne(super.setMaskByHeightDifference(d));
    }

    private double[] addOne(double[] dArray) {
        double[] dArray2 = new double[dArray.length + 1];
        dArray2[0] = 1.0;
        System.arraycopy(dArray, 0, dArray2, 1, dArray.length);
        return dArray2;
    }

    @Override
    public double[] setMaskByRatio(double d) {
        return this.addOne(super.setMaskByRatio(d));
    }

    @Override
    public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
        double[] dArray3 = super.updateGradientUnWeightedLogDensity(dArray, dArray2, n, n2);
        double[] dArray4 = new double[this.ratios.getDimension() + 1];
        dArray4[0] = this.updateHeightParameterGradientUnweightedLogDensity(dArray);
        System.arraycopy(dArray3, 0, dArray4, 1, this.ratios.getDimension());
        return dArray4;
    }

    private double[] setCombinedValues() {
        double[] dArray = new double[this.ratios.getDimension() + 1];
        System.arraycopy(this.ratios.getParameterValues(), 0, dArray, 1, this.ratios.getDimension());
        dArray[0] = this.rootHeightAndRatios.getParameterValue(0);
        return dArray;
    }

    @Override
    public double[] inverse(double[] dArray) {
        this.heightParameter.setParameterValueQuietly(0, dArray[0]);
        double[] dArray2 = this.separateRatios(dArray);
        return super.inverse(dArray2);
    }

    private double[] separateRatios(double[] dArray) {
        double[] dArray2 = new double[this.ratios.getDimension()];
        System.arraycopy(dArray, 1, dArray2, 0, dArray2.length);
        return dArray2;
    }

    @Override
    public Parameter getParameter() {
        return this.rootHeightAndRatios;
    }

    private double updateHeightParameterGradientUnweightedLogDensity(double[] dArray) {
        this.preOrderTraversal.updateAllNodes();
        this.preOrderTraversal.dispatchTreeTraversalCollectBranchAndNodeOperations();
        double[] dArray2 = new double[this.tree.getInternalNodeCount()];
        List<ProcessOnTreeDelegate.NodeOperation> list = this.preOrderTraversal.getNodeOperations();
        dArray2[this.getNodeHeightGradientIndex((NodeRef)this.tree.getRoot())] = 1.0;
        for (ProcessOnTreeDelegate.NodeOperation nodeOperation : list) {
            NodeRef nodeRef = this.tree.getNode(nodeOperation.getLeftChild());
            if (this.tree.isRoot(nodeRef) || this.tree.isExternal(nodeRef)) continue;
            double d = this.ratios.getParameterValue(this.getRatiosIndex(nodeRef));
            dArray2[this.getNodeHeightGradientIndex((NodeRef)nodeRef)] = d * dArray2[this.getNodeHeightGradientIndex(this.tree.getParent(nodeRef))];
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    private class HeightParameter
    extends Parameter.Proxy {
        private final TreeModel tree;
        private Bounds<Double> bounds;

        private HeightParameter(TreeModel treeModel, Bounds<Double> bounds) {
            super("LocationShiftedRootHeightParameter", 1);
            this.bounds = null;
            this.tree = treeModel;
            this.addBounds(bounds);
        }

        @Override
        public void addBounds(Bounds<Double> bounds) {
            this.bounds = bounds;
        }

        @Override
        public Bounds<Double> getBounds() {
            return this.bounds;
        }

        @Override
        public double getParameterValue(int n) {
            return this.tree.getNodeHeight(this.tree.getRoot()) - NodeHeightToRatiosFullTransformDelegate.this.getMaxTipHeight();
        }

        @Override
        public void setParameterValue(int n, double d) {
            this.tree.setNodeHeight(this.tree.getRoot(), NodeHeightToRatiosFullTransformDelegate.this.getRootHeight(d));
        }

        @Override
        public void setParameterValueQuietly(int n, double d) {
            this.tree.setNodeHeightQuietly(this.tree.getRoot(), NodeHeightToRatiosFullTransformDelegate.this.getRootHeight(d));
        }

        @Override
        public void setParameterValueNotifyChangedAll(int n, double d) {
            this.tree.setNodeHeight(this.tree.getRoot(), NodeHeightToRatiosFullTransformDelegate.this.getRootHeight(d));
        }
    }
}

