/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.GradientProvider;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.MarginalizedAlphaStableDistribution;

public class MarginalizedAlphaStableDistributionModel
extends AbstractModel
implements ParametricDistributionModel,
GradientProvider {
    private final Parameter scale;
    private final Parameter alpha;

    public MarginalizedAlphaStableDistributionModel(String string, Parameter parameter, Parameter parameter2) {
        super(string);
        this.scale = parameter;
        this.alpha = parameter2;
        this.addVariable(parameter);
        this.addVariable(parameter2);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return null;
    }

    @Override
    public double logPdf(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += this.logPdf(d2);
        }
        return d;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double pdf(double d) {
        return Math.exp(this.logPdf(d));
    }

    @Override
    public double logPdf(double d) {
        return MarginalizedAlphaStableDistribution.logPdf(d, this.scale.getParameterValue(0), this.alpha.getParameterValue(0));
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = MarginalizedAlphaStableDistribution.gradLogPdf(dArray[i], this.scale.getParameterValue(0), this.alpha.getParameterValue(0));
        }
        return dArray2;
    }
}

