/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.ErrorFunction;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class TruncatedNormalDistribution
implements Distribution {
    private UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return TruncatedNormalDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return TruncatedNormalDistribution.this.lower;
        }

        @Override
        public final double getUpperBound() {
            return TruncatedNormalDistribution.this.upper;
        }
    };
    private double m;
    private double sd;
    private double lower;
    private double upper;
    private double T;

    public double getMean() {
        return this.m;
    }

    public void setMdean(double d) {
        this.m = d;
    }

    public double getSD() {
        return this.sd;
    }

    public void setSD(double d) {
        this.sd = d;
    }

    public double getLower() {
        return this.lower;
    }

    public void setLower(double d) {
        this.lower = d;
    }

    public double getUpper() {
        return this.upper;
    }

    public void setUpper(double d) {
        this.upper = d;
    }

    public TruncatedNormalDistribution(double d, double d2, double d3, double d4) {
        if (d3 == d4) {
            d4 += 1.0E-4;
        }
        if (d2 == 0.0) {
            d2 = 1.0E-5;
        }
        this.m = d;
        this.sd = d2;
        this.lower = d3;
        this.upper = d4;
        double d5 = d4 != Double.POSITIVE_INFINITY ? TruncatedNormalDistribution.standardNormalCdf((d4 - d) / d2) : 1.0;
        double d6 = d3 != Double.NEGATIVE_INFINITY ? TruncatedNormalDistribution.standardNormalCdf((d3 - d) / d2) : 0.0;
        this.T = d5 - d6;
    }

    @Override
    public double pdf(double d) {
        if (d >= this.upper || d < this.lower) {
            return 0.0;
        }
        return TruncatedNormalDistribution.standardNormalPdf((d - this.m) / this.sd) / this.sd / this.T;
    }

    @Override
    public double logPdf(double d) {
        return Math.log(this.pdf(d));
    }

    @Override
    public double cdf(double d) {
        double d2 = d < this.lower ? 0.0 : (d >= this.lower && d < this.upper ? (this.lower != Double.NEGATIVE_INFINITY ? (TruncatedNormalDistribution.standardNormalCdf((d - this.m) / this.sd) - TruncatedNormalDistribution.standardNormalCdf((this.lower - this.m) / this.sd)) / this.T : TruncatedNormalDistribution.standardNormalCdf((d - this.m) / this.sd) / this.T) : 1.0);
        return d2;
    }

    @Override
    public double quantile(double d) {
        if (d == 0.0) {
            return this.lower;
        }
        if (d == 1.0) {
            return this.upper;
        }
        return this.quantileSearch(d, this.lower, this.upper, 20);
    }

    private double quantileSearch(double d, double d2, double d3, int n) {
        double d4 = (d3 + d2) / 2.0;
        if (n == 0 || d4 == d2 || d4 == d3) {
            return d4;
        }
        double d5 = this.cdf(d4);
        if (d <= d5) {
            return this.quantileSearch(d, d2, d4, n - 1);
        }
        return this.quantileSearch(d, d4, d3, n - 1);
    }

    @Override
    public double mean() {
        return TruncatedNormalDistribution.mean(this.m, this.sd, this.lower, this.upper);
    }

    @Override
    public double variance() {
        return TruncatedNormalDistribution.mean(this.m, this.sd, this.lower, this.upper);
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double standardNormalPdf(double d) {
        double d2 = 1.0 / Math.sqrt(Math.PI * 2);
        double d3 = -d * d / 2.0;
        return d2 * Math.exp(d3);
    }

    public static double logStandardNormalPdf(double d) {
        return Math.log(TruncatedNormalDistribution.standardNormalPdf(d));
    }

    public static double standardNormalCdf(double d) {
        double d2 = d / Math.sqrt(2.0);
        return 0.5 * (1.0 + ErrorFunction.erf(d2));
    }

    public static double mean(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / d2;
        double d6 = (d3 - d) / d2;
        double d7 = TruncatedNormalDistribution.standardNormalPdf(d5);
        double d8 = TruncatedNormalDistribution.standardNormalPdf(d6);
        double d9 = TruncatedNormalDistribution.standardNormalCdf(d5);
        double d10 = TruncatedNormalDistribution.standardNormalCdf(d6);
        return d - d2 * (d7 - d8) / (d9 - d10);
    }

    public static double variance(double d, double d2, double d3, double d4) {
        double d5 = (d4 - d) / d2;
        double d6 = (d3 - d) / d2;
        double d7 = TruncatedNormalDistribution.standardNormalPdf(d5);
        double d8 = TruncatedNormalDistribution.standardNormalPdf(d6);
        double d9 = TruncatedNormalDistribution.standardNormalCdf(d5);
        double d10 = TruncatedNormalDistribution.standardNormalCdf(d6);
        double d11 = (d5 * d7 - d6 * d8) / (d9 - d10);
        double d12 = (d7 - d8) / (d9 - d10);
        return d2 * d2 * (1.0 - d11 - d12 * d12);
    }
}

