## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ConFluxPro)

## ----base_dat-----------------------------------------------------------------
data("base_dat", package = "ConFluxPro")

## ----base_flux, warning=FALSE-------------------------------------------------
mod_pf <- pro_flux(base_dat)
mod_fg <- fg_flux(base_dat)

## ----base_list----------------------------------------------------------------
names(mod_pf)
names(mod_fg)

## ----base_efflux--------------------------------------------------------------
efflux_pf <- efflux(mod_pf)
efflux_fg <- efflux(mod_fg)

head(efflux_pf)

## -----------------------------------------------------------------------------
production_pf <- production(mod_pf)
production_fg <- production(mod_fg)

head(production_pf)

## ----flux-modes, warning=FALSE------------------------------------------------
mod_fg_ef <- fg_flux(base_dat, modes = "EF")
mod_fg_multiple_modes <- fg_flux(base_dat, 
                                 modes = c("LL", "LS", "EF"),
                                 gases = rep("CO2", 3))

## ----flux-param---------------------------------------------------------------
mod_fg_more_params <- 
  fg_flux(base_dat, 
          modes = "LL",
          gases = "CO2",
          param = c("c_air", "DS", "SWC", "t"),
          funs = c("arith", "harm", "arith", "harm"))

## ----efflux-top---------------------------------------------------------------
efflux_fg_top <- efflux(mod_fg, method = "top")

## ----fg_ef--------------------------------------------------------------------
efflux_fg_lm <- efflux(mod_fg, method = "lm")
efflux_mod_lex <- efflux(mod_fg, method = "lex", layers = c(1, 2))

## ----fg_prod------------------------------------------------------------------
production_fg <- production(mod_fg)

## ----pf_zf--------------------------------------------------------------------
mod_pf_with_flux <- pro_flux(base_dat, 
                             zero_flux = FALSE,
                             zero_limits = c(-1000, 1000))

## ----pf_df--------------------------------------------------------------------
deepflux(mod_pf_with_flux) |>
  head()

## ----pf_ef--------------------------------------------------------------------
EFFLUX_pf <- efflux(mod_pf)
head(EFFLUX_pf)

## ----pf_prod------------------------------------------------------------------
PRODUCTION_pf <- production(mod_pf)
head(PRODUCTION_pf)

