## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
y.lab <- expression(- log[10]~italic(p)*plain(-value)) # "-Log10(p-value)"

## ----include=FALSE------------------------------------------------------------
require(Upsilon)
require(ggplot2)
library(patchwork)
#require(gtools)
require(FunChisq)
require(DescTools)
require(USP)
require(metan)
methods_level = c("Upsilon","Pearson's chi-squared","Fisher's Exact","G-Test","USP")

## ----echo=FALSE, fig.width=12, fig.height=12, out.width="90%", fig.align='center', warning=FALSE, message=FALSE----

T1 = matrix(c(6,0,0,
              0,6,0,
              0,0,6
            ), nrow = 3, byrow = T)

upsilon_pvalue1 = as.numeric(upsilon.test(T1)$p.value)
chisq_pvalue1 = as.numeric(modified.chisq.test(T1)$p.value)
fisher_pvalue1 = fisher.test(T1)$p.value
gtest_pvalue1 = as.numeric(modified.gtest(T1)$p.value)
usp_pvalue1 = USP.test(T1)$p.value

marginal_pvalue1 = data.frame("p.value" = c(upsilon_pvalue1,chisq_pvalue1,fisher_pvalue1,gtest_pvalue1,usp_pvalue1))
marginal_pvalue1$Method = methods_level
marginal_pvalue1$table = ifelse(marginal_pvalue1$p.value <= 0.05, "Significant", "Insignificant")
marginal_pvalue1$table = factor(marginal_pvalue1$table, levels = c("Significant", "Insignificant"))
marginal_pvalue1$log.p.value = -log10(marginal_pvalue1$p.value)
y_max = max(marginal_pvalue1$log.p.value)

T2 = matrix(c(16,0,0,
              0,1,0,
              0,0,1), nrow = 3, byrow = T)

upsilon_pvalue2 = as.numeric(upsilon.test(T2)$p.value)
chisq_pvalue2 = as.numeric(modified.chisq.test(T2)$p.value)
fisher_pvalue2 = fisher.test(T2)$p.value
gtest_pvalue2 = as.numeric(modified.gtest(T2)$p.value)
usp_pvalue2 = USP.test(T2)$p.value

marginal_pvalue2 = data.frame("p.value" = c(upsilon_pvalue2,chisq_pvalue2,fisher_pvalue2,gtest_pvalue2,usp_pvalue2))
marginal_pvalue2$Method = methods_level
marginal_pvalue2$table = ifelse(marginal_pvalue2$p.value <= 0.05, "Significant", "Insignificant")
marginal_pvalue2$table = factor(marginal_pvalue2$table, levels = c("Significant", "Insignificant"))
marginal_pvalue2$log.p.value = -log10(marginal_pvalue2$p.value)
p1_table <- plot_matrix(T1, title = "Table 1. Dominant function", 
                        shape.color = "palegreen", size.by = "none",x.axis = "",y.axis = "",
                        number.size = 8) +
  theme(plot.title = element_text(size = 22, face = "bold"))


p2_table <- plot_matrix(
  T2, title = "Table 2. Dominant constant function", 
  shape.color = "lavender", size.by = "none", 
  x.axis = "", y.axis = "",
  number.size = 8) +
  theme(plot.title = element_text(size = 22, face = "bold"))


p3_bar <- ggplot(data = marginal_pvalue1, aes(x = factor(Method, levels = methods_level), y = log.p.value, fill = table)) +
  geom_bar(stat = "identity", position = "dodge", color = "white") +
  scale_y_continuous(trans = "sqrt", name = y.lab,
                     limits = c(0,y_max)) +
  #geom_hline(yintercept = -log10(0.05), linetype = "dashed", color = "black")+
  labs(title = NULL, x = NULL, y = y.lab, fill = "") +
  scale_fill_manual(values = c("Significant" = "lightblue1", "Insignificant" = "lightpink")) +
  geom_text(aes(label = format(p.value, scientific = TRUE, digits = 1),
                vjust = ifelse(log.p.value < 1.0, -0.5, 1.5)), size=6,
            position = position_dodge(width = 0.9)) +
  theme(axis.text.x = element_text(angle = 15, hjust = 1, face = "bold", size = 16),
        axis.text.y = element_text(size = 15),
        axis.title.y = element_text(size = 20),
        legend.position = "top", 
        legend.key.size = unit(1.5, "lines"),
        legend.text = element_text(size = 25),
        aspect.ratio = 1)


p4_bar <- ggplot(data = marginal_pvalue2, aes(x = factor(Method, levels = methods_level), y = log.p.value, fill = table)) +
  geom_bar(stat = "identity", position = "dodge", color = "white") +
  scale_y_continuous(trans = "sqrt", name = y.lab, limits = c(0,y_max)) +
  #geom_hline(yintercept = -log10(0.05), linetype = "dashed", color = "black")+
  labs(title = NULL, x = NULL, y = y.lab, fill = "") +
  scale_fill_manual(values = c("Significant" = "lightblue1", "Insignificant" = "lightpink")) +
  geom_text(aes(label = format(p.value, scientific = TRUE, digits = 1),
                vjust = ifelse(log.p.value < 1.0, -0.5, 1.5)), size=6,
            position = position_dodge(width = 0.9)) +
  theme(axis.text.x = element_text(angle = 15, hjust = 1, face = "bold", size = 16),
        axis.text.y = element_text(size = 15),
        axis.title.y = element_text(size = 20),
        legend.position = "top", 
        legend.key.size = unit(1.5, "lines"),legend.text = element_text(size = 25),
        aspect.ratio = 1)


final_plot <- (p1_table / p3_bar) | (p2_table / p4_bar)
final_plot

## ----echo =FALSE, fig.width=12, fig.height=12, out.width="90%", fig.align='center', warning=FALSE, message=FALSE----


T1 = matrix(c(10,1,1,
              1,10,1,
              1,1,1), nrow = 3, byrow = T)

upsilon_pvalue1 = as.numeric(upsilon.test(T1)$p.value)
chisq_pvalue1 = as.numeric(modified.chisq.test(T1)$p.value) 
fisher_pvalue1 = fisher.test(T1)$p.value
gtest_pvalue1 = as.numeric(modified.gtest(T1)$p.value)
usp_pvalue1 = USP.test(T1)$p.value

marginal_pvalue1 = data.frame("p.value" = c(upsilon_pvalue1,chisq_pvalue1,fisher_pvalue1,gtest_pvalue1,usp_pvalue1))
marginal_pvalue1$Method = methods_level
marginal_pvalue1$table = ifelse(marginal_pvalue1$p.value <= 0.05, "Significant", "Insignificant")
marginal_pvalue1$table = factor(marginal_pvalue1$table, levels = c("Significant", "Insignificant"))
marginal_pvalue1$log.p.value = -log10(marginal_pvalue1$p.value)
y_max = max(marginal_pvalue1$log.p.value)


T2 = matrix(c(10,1,1,
              1,10,1,
              100,100,100), nrow = 3, byrow = T)

upsilon_pvalue2 = as.numeric(upsilon.test(T2)$p.value)
chisq_pvalue2 = as.numeric(modified.chisq.test(T2)$p.value)
fisher_pvalue2 = fisher.test(T2)$p.value
gtest_pvalue2 = as.numeric(modified.gtest(T2)$p.value)
usp_pvalue2 = USP.test(T2)$p.value

marginal_pvalue2 = data.frame("p.value" = c(upsilon_pvalue2,chisq_pvalue2,fisher_pvalue2,gtest_pvalue2,usp_pvalue2))
marginal_pvalue2$Method = methods_level
marginal_pvalue2$table = ifelse(marginal_pvalue2$p.value <= 0.05, "Significant", "Insignificant")
marginal_pvalue2$table = factor(marginal_pvalue2$table, levels = c("Significant", "Insignificant"))
marginal_pvalue2$log.p.value = -log10(marginal_pvalue2$p.value)


p1_table <- plot_matrix(T1, title = "Table 3. Dominant function", 
                        shape.color = "palegreen", size.by = "none", 
                        x.axis = "", y.axis = "",
                        number.size = 8) +
  theme(plot.title = element_text(size = 22, face = "bold"))


p2_table <- plot_matrix(T2, title = "Table 4. Non-dominant function", 
                        shape.color = "lavender", size.by = "none", 
                        x.axis = "", y.axis = "",
                        number.size = 8) +
  theme(plot.title = element_text(size = 22, face = "bold"))


p3_bar <- ggplot(data = marginal_pvalue1, aes(x = factor(Method, levels = methods_level), y = log.p.value, fill = table)) +
  geom_bar(stat = "identity", position = "dodge", color = "white") +
  scale_y_continuous(trans = "sqrt", name = y.lab, limits = c(0, y_max)) +
  labs(title = NULL, x = NULL, y = y.lab, fill = "") +
  scale_fill_manual(values = c("Significant" = "lightblue1", "Insignificant" = "lightpink")) +
  geom_text(aes(label = format(p.value, scientific = TRUE, digits = 1),
                vjust = ifelse(log.p.value < 1.0, -0.5, 1.5)), size = 6,
            position = position_dodge(width = 0.9)) +
  theme_minimal() +
  theme(axis.text.x = element_text(angle = 15, hjust = 1, face = "bold", size = 16),
        axis.text.y = element_text(size = 15),
        axis.title.y = element_text(size = 20),
        legend.position = "top", 
        legend.key.size = unit(1.5, "lines"),
        legend.text = element_text(size = 25),
        aspect.ratio = 1)


p4_bar <- ggplot(data = marginal_pvalue2, aes(x = factor(Method, levels = methods_level), y = log.p.value, fill = table)) +
  geom_bar(stat = "identity", position = "dodge", color = "white") +
  scale_y_continuous(trans = "sqrt", name = y.lab, limits = c(0, y_max)) +
  labs(title = NULL, x = NULL, y = y.lab, fill = "") +
  scale_fill_manual(values = c("Significant" = "lightblue1", "Insignificant" = "lightpink")) +
  geom_text(aes(label = format(p.value, scientific = TRUE, digits = 1),
                vjust = ifelse(log.p.value < 1.0, -0.5, 1.5)), size = 6,
            position = position_dodge(width = 0.9)) +
  theme_minimal() +
  theme(axis.text.x = element_text(angle = 15, hjust = 1, face = "bold", size = 16),
        axis.text.y = element_text(size = 15),
        axis.title.y = element_text(size = 20),
        legend.position = "top", 
        legend.key.size = unit(1.5, "lines"),
        legend.text = element_text(size = 25),
        aspect.ratio = 1)


final_plot <- (p1_table / p3_bar) | (p2_table / p4_bar)

final_plot

## ----echo = FALSE, fig.width=12, fig.height=12, out.width="90%", fig.align='center', warning=FALSE, message=FALSE----
library(ggplot2)
library(patchwork)
library(Upsilon)



T1 = matrix(c(30,30,1,
              1,1,0), nrow = 2, byrow = T)

upsilon_pvalue1 = as.numeric(upsilon.test(T1)$p.value)
chisq_pvalue1 = as.numeric(modified.chisq.test(T1)$p.value) 
fisher_pvalue1 = fisher.test(T1)$p.value
gtest_pvalue1 = as.numeric(modified.gtest(T1)$p.value)
usp_pvalue1 = USP.test(T1)$p.value

marginal_pvalue1 = data.frame("p.value" = c(upsilon_pvalue1,chisq_pvalue1,fisher_pvalue1,gtest_pvalue1,usp_pvalue1))
marginal_pvalue1$Method = methods_level
marginal_pvalue1$table = ifelse(marginal_pvalue1$p.value <= 0.05, "Significant", "Insignificant")
marginal_pvalue1$table = factor(marginal_pvalue1$table, levels = c("Significant", "Insignificant"))
marginal_pvalue1$log.p.value = -log10(marginal_pvalue1$p.value)

T2 = matrix(c(30,30,0,
              1,1,1), nrow = 2, byrow = T)

upsilon_pvalue2 = as.numeric(upsilon.test(T2)$p.value)
chisq_pvalue2 = as.numeric(modified.chisq.test(T2)$p.value)
fisher_pvalue2 = fisher.test(T2)$p.value
gtest_pvalue2 = as.numeric(modified.gtest(T2)$p.value)
usp_pvalue2 = USP.test(T2)$p.value

marginal_pvalue2 = data.frame("p.value" = c(upsilon_pvalue2,chisq_pvalue2,fisher_pvalue2,gtest_pvalue2,usp_pvalue2))
marginal_pvalue2$Method = methods_level
marginal_pvalue2$table = ifelse(marginal_pvalue2$p.value <= 0.05, "Significant", "Insignificant")
marginal_pvalue2$table = factor(marginal_pvalue2$table, levels = c("Significant", "Insignificant"))
marginal_pvalue2$log.p.value = -log10(marginal_pvalue2$p.value)
y_max = max(marginal_pvalue2$log.p.value)


p1_table <- plot_matrix(T1, title = "Table 5. Non-function", 
                        shape.color = "lavender", size.by = "none", 
                        x.axis = "", y.axis = "",
                        number.size = 8) +
  theme(plot.title = element_text(size = 22, face = "bold"))


p2_table <- plot_matrix(T2, title = "Table 6. Non-function", 
                        shape.color = "lavender", size.by = "none", 
                        x.axis = "", y.axis = "",
                        number.size = 8) +
  theme(plot.title = element_text(size = 22, face = "bold"))


p3_bar <- ggplot(data = marginal_pvalue1, aes(x = factor(Method, levels = methods_level), y = log.p.value, fill = table)) +
  geom_bar(stat = "identity", position = "dodge", color = "white") +
  scale_y_continuous(trans = "sqrt", name = y.lab, limits = c(0, y_max)) +
  labs(title = NULL, x = NULL, y = y.lab, fill = "") +
  scale_fill_manual(values = c("Significant" = "lightblue1", "Insignificant" = "lightpink")) +
  geom_text(aes(label = format(p.value, scientific = FALSE, digits = 2),
                vjust = ifelse(log.p.value < 1.0, -0.5, 1.5)), size = 6,
            position = position_dodge(width = 0.9)) +
  theme_minimal() +
  theme(axis.text.x = element_text(angle = 15, hjust = 1, face = "bold", size = 16),
        axis.text.y = element_text(size = 15),
        axis.title.y = element_text(size = 20),
        legend.position = "top", 
        legend.key.size = unit(1.5, "lines"),
        legend.text = element_text(size = 25),
        aspect.ratio = 1) 


p4_bar <- ggplot(data = marginal_pvalue2, aes(x = factor(Method, levels = methods_level), y = log.p.value, fill = table)) +
  geom_bar(stat = "identity", position = "dodge", color = "white") +
  scale_y_continuous(trans = "sqrt", name = y.lab, limits = c(0, y_max)) +
  labs(title = NULL, x = NULL, y = y.lab, fill = "") +
  scale_fill_manual(values = c("Significant" = "lightblue1", "Insignificant" = "lightpink")) +
  geom_text(aes(label = format(p.value, scientific = TRUE, digits = 1),
                vjust = ifelse(log.p.value < 1.0, -0.5, 1.5)), size = 6,
            position = position_dodge(width = 0.9)) +
  theme_minimal() +
  theme(axis.text.x = element_text(angle = 15, hjust = 1, face = "bold", size = 16),
        axis.text.y = element_text(size = 15),
        axis.title.y = element_text(size = 20),
        legend.position = "top", 
        legend.key.size = unit(1.5, "lines"),
        legend.text = element_text(size = 25),
        aspect.ratio = 1) 

final_plot <- (p1_table / p3_bar) | (p2_table / p4_bar)

final_plot

## ----include=FALSE------------------------------------------------------------
T1= matrix(c(6,0,
                        8,12,
                        8,15,
                        2,1),nrow = 4,byrow = T)
upsilon_pvalue1 = as.numeric(upsilon.test(T1)$p.value)
chisq_pvalue1 = as.numeric(modified.chisq.test(T1)$p.value) 
fisher_pvalue1 = fisher.test(T1)$p.value
gtest_pvalue1 = as.numeric(modified.gtest(T1)$p.value)
usp_pvalue1 = USP.test(T1)$p.value

marginal_pvalue1 = data.frame("p.value" = c(upsilon_pvalue1,chisq_pvalue1,fisher_pvalue1,gtest_pvalue1,usp_pvalue1))
marginal_pvalue1$Method = methods_level
marginal_pvalue1$table = ifelse(marginal_pvalue1$p.value <= 0.05, "Significant", "Insignificant")
marginal_pvalue1$table = factor(marginal_pvalue1$table, levels = c("Significant", "Insignificant"))
marginal_pvalue1$log.p.value = -log10(marginal_pvalue1$p.value)

## ----echo = FALSE, fig.width=12, fig.height=6, out.width="90%", fig.align='center', warning=FALSE, message=FALSE----
y_max = max(marginal_pvalue1$log.p.value)

p_bar <- ggplot(data = marginal_pvalue1, aes(x = factor(Method, levels = methods_level), y = log.p.value, fill = table)) +
  geom_bar(stat = "identity", position = "dodge", color = "white") +
  # scale_y_continuous(trans = "sqrt", name = y.lab, limits = c(0, y_max)) +
  labs(title = NULL, x = NULL, y = y.lab, fill = "") +
  scale_fill_manual(values = c("Significant" = "lightblue1", "Insignificant" = "lightpink")) +
  geom_text(aes(label = format(p.value, scientific = FALSE, digits = 1),
                vjust = ifelse(log.p.value < 0.5, -0.5, 1.5)), size=12,
            position = position_dodge(width = 0.9)) +
  theme_minimal() +
  theme(axis.text.x = element_text(angle = 15, hjust = 1, face = "bold", size = 25),
        axis.text.y = element_text(size = 18),
        axis.title.y = element_text(size = 25),
        legend.position = "top", 
        legend.key.size = unit(1.5, "lines"),
        legend.text = element_text(size = 25)) 
p_bar

## ----include=FALSE------------------------------------------------------------
T1= matrix(c(359,133,234,
                        257,96,253
             ),nrow = 2,byrow = T)
upsilon_pvalue1 = as.numeric(upsilon.test(T1)$p.value)
chisq_pvalue1 = as.numeric(modified.chisq.test(T1)$p.value) 
fisher_pvalue1 = fisher.test(T1)$p.value
gtest_pvalue1 = as.numeric(modified.gtest(T1)$p.value)
usp_pvalue1 = USP.test(T1)$p.value

marginal_pvalue1 = data.frame("p.value" = c(upsilon_pvalue1,chisq_pvalue1,fisher_pvalue1,gtest_pvalue1,usp_pvalue1))
marginal_pvalue1$Method = methods_level
marginal_pvalue1$table = ifelse(marginal_pvalue1$p.value <= 0.05, "Significant", "Insignificant")
marginal_pvalue1$table = factor(marginal_pvalue1$table, levels = c("Significant", "Insignificant"))
marginal_pvalue1$log.p.value = -log10(marginal_pvalue1$p.value)

## ----echo = FALSE, fig.width=12, fig.height=6, out.width="90%", fig.align='center', warning=FALSE, message=FALSE----
y_max = max(marginal_pvalue1$log.p.value)
p_bar <- ggplot(data = marginal_pvalue1, aes(x = factor(Method, levels = methods_level), y = log.p.value, fill = table)) +
  geom_bar(stat = "identity", position = "dodge", color = "white") +
#  scale_y_continuous(trans = "sqrt", name = y.lab, limits = c(0, y_max)) +
  labs(title = NULL, x = NULL, y = y.lab, fill = "") +
  scale_fill_manual(values = c("Significant" = "lightblue1", "Insignificant" = "lightpink")) +
  geom_text(aes(label = format(p.value, scientific = FALSE, digits = 1),
                vjust = ifelse(log.p.value < 1.0, -0.5, 1.5)), size=10,
            position = position_dodge(width = 0.9)) +
  theme_minimal() +
  theme(axis.text.x = element_text(angle = 15, hjust = 1, face = "bold", size = 25),
        axis.text.y = element_text(size = 18),
        axis.title.y = element_text(size = 25),
        legend.position = "top", 
        legend.key.size = unit(1.5, "lines"),
        legend.text = element_text(size = 25)) 
p_bar

