## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

options(rmarkdown.html_vignette.check_title = FALSE)

## ----eval=FALSE, include=TRUE-------------------------------------------------
# install_r_tensorflow(python_path = "system_path_of_python.exe", env_name = "r-tensorflow")

## ----eval=FALSE, include=TRUE-------------------------------------------------
# install_r_tensorflow(python_path = "C:/Users/User_name/AppData/Local/Programs/Python/Python312/python.exe", env_name = "r-tensorflow")

## ----eval=FALSE, include=TRUE-------------------------------------------------
# install_r_keras(tensorflow_python_path = "virtual_environment_path_of_python.exe", env_name = "r-tensorflow")

## ----eval=FALSE, include=TRUE-------------------------------------------------
# install_r_keras(tensorflow_python_path = "C:/Users/kabil/Documents/.virtualenvs/r-tensorflow/Scripts/python.exe", env_name = "r-tensorflow")

## ----eval=FALSE, include=TRUE-------------------------------------------------
# install_r_pandas(tensorflow_python_path = "virtual_environment_path_of_python.exe", env_name = "r-tensorflow")

## ----eval=FALSE, include=TRUE-------------------------------------------------
# install_r_pandas(tensorflow_python_path = "C:/Users/kabil/Documents/.virtualenvs/r-tensorflow/Scripts/python.exe", env_name = "r-tensorflow")

## ----eval=FALSE, include=TRUE-------------------------------------------------
# library(transformerForecasting)
# data("S_P_500_Close_data")
# df <- S_P_500_Close_data

## ----eval=FALSE, include=TRUE-------------------------------------------------
# result <- TRANSFORMER(
#   df = df,
#   study_variable = "Price",
#   tensorflow_python_path = "C:/Users/kabil/Documents/.virtualenvs/r-tensorflow/Scripts/python.exe",
#   env_name = "r-tensorflow",
#   sequence_size = 10,
#   head_size = 128,
#   num_heads = 8,
#   ff_dim = 256,
#   num_transformer_blocks = 4,
#   mlp_units = c(128),
#   mlp_dropout = 0.3,
#   dropout = 0.2,
#   epochs = 100,
#   batch_size = 32,
#   patience = 15
# )

## ----eval=FALSE, include=TRUE-------------------------------------------------
# result$PREDICTIONS

## ----eval=FALSE, include=TRUE-------------------------------------------------
# result$RMSE

## ----eval=FALSE, include=TRUE-------------------------------------------------
# result$MAE

## ----eval=FALSE, include=TRUE-------------------------------------------------
# result$MAPE

## ----eval=FALSE, include=TRUE-------------------------------------------------
# result$sMAPE

## ----eval=FALSE, include=TRUE-------------------------------------------------
# result$RRMSE

## ----eval=FALSE, include=TRUE-------------------------------------------------
# result$Quantile_Loss

## ----eval=FALSE, include=TRUE-------------------------------------------------
# result$Loss_plot

## ----echo=FALSE, out.width = "500px"------------------------------------------
knitr::include_graphics("images/loss_plot.png", dpi = 72)

## ----eval=FALSE, include=TRUE-------------------------------------------------
# result$Actual_vs_Predicted

## ----echo=FALSE, out.width = "500px"------------------------------------------
knitr::include_graphics("images/act_vs_pred.png", dpi = 72)

