/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.thorney;

import dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel;
import dr.evomodel.bigfasttree.thorney.MutationBranchMap;
import dr.evomodel.treedatalikelihood.discrete.MaskProvider;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ZeroMutationMasker
implements MaskProvider {
    private final ConstrainedTreeModel tree;
    private final Parameter mask;
    private final MutationBranchMap branchLengthProvider;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        static final String MASKER = "ZeroMutationMasker";
        static final String MASK = "mask";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("mask", Parameter.class), new ElementRule(ConstrainedTreeModel.class), new ElementRule(MutationBranchMap.class)};

        @Override
        public String getParserName() {
            return MASKER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(MASK).getChild(Parameter.class);
            ConstrainedTreeModel constrainedTreeModel = (ConstrainedTreeModel)xMLObject.getChild(ConstrainedTreeModel.class);
            MutationBranchMap mutationBranchMap = (MutationBranchMap)xMLObject.getChild(MutationBranchMap.class);
            if (parameter.getDimension() == 1) {
                parameter.setDimension(constrainedTreeModel.getInternalNodeCount());
            }
            return new ZeroMutationMasker(constrainedTreeModel, parameter, mutationBranchMap);
        }

        @Override
        public String getParserDescription() {
            return "A utility to craft mask for filtering dimensions in where nodes do not have any mutations";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return ZeroMutationMasker.class;
        }
    };

    public ZeroMutationMasker(ConstrainedTreeModel constrainedTreeModel, Parameter parameter, MutationBranchMap mutationBranchMap) {
        this.tree = constrainedTreeModel;
        this.mask = parameter;
        this.branchLengthProvider = mutationBranchMap;
        this.updateMask();
    }

    @Override
    public Parameter getMask() {
        return this.mask;
    }

    @Override
    public void updateMask() {
        for (int i = 0; i < this.mask.getDimension(); ++i) {
            double d = this.branchLengthProvider.getMutations(this.tree.getInternalNode(i)).getMutationCount() > 0.0 ? 1.0 : 0.0;
            this.mask.setParameterValueQuietly(i, d);
        }
        this.mask.fireParameterChangedEvent();
    }
}

