/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.operators.GeneralOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleOperator;
import java.util.logging.Logger;

public abstract class SimpleMetropolizedGibbsOperator
extends SimpleOperator
implements GeneralOperator {
    public abstract double doOperation(Likelihood var1);

    public abstract int getStepCount();

    @Override
    public abstract String getOperatorName();

    @Override
    public final double operate() {
        return this.operate(null);
    }

    @Override
    public final double operate(Likelihood likelihood) {
        if (this.operateAllowed) {
            this.operateAllowed = false;
            return this.doOperation(likelihood);
        }
        throw new RuntimeException("Operate called twice without accept/reject in between!");
    }

    public final double getMaximumAcceptanceLevel() {
        return 1.0;
    }

    public final double getMaximumGoodAcceptanceLevel() {
        return 1.0;
    }

    public final double getMinimumAcceptanceLevel() {
        return 0.005;
    }

    public final double getMinimumGoodAcceptanceLevel() {
        return 0.01;
    }

    public final String getPerformanceSuggestion() {
        return "";
    }

    public final double getTargetAcceptanceProbability() {
        return 1.0;
    }

    protected double evaluate(Likelihood likelihood, double d) {
        double d2 = 0.0;
        double d3 = likelihood.getLogLikelihood() * d;
        if (Double.isNaN(d3)) {
            return Double.NEGATIVE_INFINITY;
        }
        return d2 += d3;
    }

    protected void restore(Likelihood likelihood, Model model, MCMCOperator mCMCOperator, double d) {
        model.restoreModelState();
        likelihood.makeDirty();
        double d2 = this.evaluate(likelihood, 1.0);
        if (Math.abs(d2 - d) > 1.0E-6) {
            Logger.getLogger("error").severe("State was not correctly restored after reject step.\nLikelihood before: " + d + " Likelihood after: " + d2 + "\nOperator: " + mCMCOperator + " " + mCMCOperator.getOperatorName());
        }
    }
}

