## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

torch_works <- tryCatch({
  torch::torch_is_installed()
}, error = function(e) FALSE)

if (!torch_works) {
  knitr::opts_chunk$set(eval = FALSE)
  warning_msg <- "**Note:** This vignette was built on a system where Torch is not installed. Code chunks are displayed but not evaluated."
} else {
  warning_msg <- ""
}

## ----setup, echo=TRUE, results='hide', message=FALSE, warning=FALSE-----------
library(NNMoMo)

## ----model setup--------------------------------------------------------------
model_basic <- lcNN()

model_CNN_Poisson <- lcNN(loss_type = "Poisson",
                          activation = "tanh", 
                          model_type = "CNN", 
                          q_z1 = 50)

## ----print of model setup-----------------------------------------------------
model_CNN_Poisson

summary(model_CNN_Poisson)

## ----data setup---------------------------------------------------------------
nn_data <- NNMoMoData(NNMoMo_data_USA, 
                      NNMoMo_data_CAN,
                      NNMoMo_data_AUS,
                      NNMoMo_data_JPN,
                      NNMoMo_data_GBR)

## ----print of data------------------------------------------------------------
nn_data

summary(nn_data)

## ----fitting, echo=TRUE, results='hide', message=FALSE, warning=FALSE---------
fitted_basic <- fit(model_basic,
                    nn_data, 
                    years.fit = 1950:1999,
                    ages.fit = 0:99,
                    fitting.epochs = 5)

fitted_CNN_Poisson <- fit(model_CNN_Poisson, 
                          nn_data, 
                          years.fit = 1950:1999, 
                          ages.fit = 0:99,
                          fitting.epochs = 5)

## -----------------------------------------------------------------------------
fitted_CNN_Poisson

summary(fitted_CNN_Poisson)

## ----loading pretrained sets, echo = FALSE, results = 'hide', message = TRUE, warning = FALSE----
if (file.exists("fitted_basic_2000.RData")) {
  load("fitted_basic_2000.RData")
} else {
  message("Pre-fitted model 'fitted_basic_2000' not found. Fitting of new one started...")
  fitted_basic_2000 <- fit(model_basic,
                           nn_data, 
                           years.fit = 1950:1999,
                           ages.fit = 0:99,
                           fitting.epochs = 2000)
}

if (file.exists("fitted_CNN_Poisson_2000.RData")) {
  load("fitted_CNN_Poisson_2000.RData")
} else {
  message("Pre-fitted model 'fitted_CNN_Poisson_2000' not found. Fitting of new one started...")
  fitted_CNN_Poisson_2000 <- fit(model_CNN_Poisson, 
                                 nn_data, 
                                 years.fit = 1950:1999, 
                                 ages.fit = 0:99,
                                 fitting.epochs = 2000)
}

## ----plotting, fig.width = 7, fig.height = 5----------------------------------
plot(fitted_basic_2000$USA_female)
plot(fitted_CNN_Poisson_2000$USA_female)

## ----residuals----------------------------------------------------------------
try(residuals(fitted_basic_2000$USA_female, scale = TRUE))

## -----------------------------------------------------------------------------
try(logLik(fitted_basic_2000$USA_female))

