# Enter the factor "Aggregate Type" in.
# Repeat each factor 12 times.
Aggregate <- factor( rep( c( "Basalt", "Silicious" ), 
                          rep( 12, 2 ) 
                        ) 
                   )

# Enter the factor "Compaction Method" in.
# Firstly place each factor into a larger virtual factor,
# then repeat that larger virtual factor 6 times.
Compaction <- factor( rep( rep( c( "Static", "Regular", 
                                   "Low", "Extremely Low" ),
                                rep( 1, 4 )
                              ),
                              6
                          )
                    )

# Enter the data "Strength" in.
Strength <- c( 68, 126, 93, 56,
               63, 128, 101, 59,
               65, 133, 98, 57,
               71, 107, 63, 40,
               66, 110, 60, 41,
               66, 116, 59, 44 )

# Create a data frame out of the 3 variables.
Asphalt.df <- data.frame( Aggregate, Compaction, Strength )

# Carry out an analysis of variance.    
Asphalt.aov <- aov( Strength ~ Aggregate * Compaction, Asphalt.df )

#interaction.plot( Compaction, Aggregate, Strength,
#                  main = "Effect of Aggregate Type against Compaction Method" )
