/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMDocumentImplUtil;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.llom.OMContainerHelper;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.om.impl.llom.OMSerializableImpl;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenLocalNameIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenNamespaceIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenQNameIterator;

public class OMDocumentImpl
extends OMSerializableImpl
implements OMDocument,
OMContainerEx {
    protected OMElement documentElement;
    protected OMNode firstChild;
    protected OMNode lastChild;
    protected String charSetEncoding = "UTF-8";
    protected String xmlVersion = "1.0";
    protected String isStandalone;

    public OMDocumentImpl(OMFactory factory) {
        super(factory);
        this.done = true;
    }

    public OMDocumentImpl(OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(factory);
        this.builder = parserWrapper;
    }

    public OMDocumentImpl(OMElement documentElement, OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(factory);
        this.documentElement = documentElement;
        this.builder = parserWrapper;
    }

    @Override
    public OMXMLParserWrapper getBuilder() {
        return this.builder;
    }

    @Override
    public OMElement getOMDocumentElement() {
        while (this.documentElement == null && this.builder != null) {
            this.builder.next();
        }
        return this.documentElement;
    }

    @Override
    public void setOMDocumentElement(OMElement documentElement) {
        this.documentElement = documentElement;
    }

    @Override
    public void setComplete(boolean state) {
        this.done = state;
    }

    @Override
    public void buildNext() {
        if (this.builder != null && !this.builder.isCompleted()) {
            this.builder.next();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addChild(OMNode child) {
        if (child.getType() == 1) {
            if (this.documentElement != null) throw new OMException("Document element already exists");
            this.addChild((OMNodeImpl)child);
            this.documentElement = (OMElement)child;
            return;
        } else {
            this.addChild((OMNodeImpl)child);
        }
    }

    private void addChild(OMNodeImpl child) {
        if (this.firstChild == null) {
            this.firstChild = child;
            child.setPreviousOMSibling(null);
        } else {
            child.setPreviousOMSibling(this.lastChild);
            ((OMNodeEx)this.lastChild).setNextOMSibling(child);
        }
        child.setNextOMSibling(null);
        child.setParent(this);
        this.lastChild = child;
    }

    @Override
    public Iterator getChildren() {
        return new OMChildrenIterator(this.getFirstOMChild());
    }

    @Override
    public Iterator getChildrenWithName(QName elementQName) {
        return new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
    }

    @Override
    public Iterator getChildrenWithLocalName(String localName) {
        return new OMChildrenLocalNameIterator(this.getFirstOMChild(), localName);
    }

    @Override
    public Iterator getChildrenWithNamespaceURI(String uri) {
        return new OMChildrenNamespaceIterator(this.getFirstOMChild(), uri);
    }

    @Override
    public OMNode getFirstOMChild() {
        while (this.firstChild == null && !this.done) {
            this.buildNext();
        }
        return this.firstChild;
    }

    @Override
    public OMNode getFirstOMChildIfAvailable() {
        return this.firstChild;
    }

    @Override
    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        OMChildrenQNameIterator omChildrenQNameIterator = new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
        OMNode omNode = null;
        if (omChildrenQNameIterator.hasNext()) {
            omNode = (OMNode)omChildrenQNameIterator.next();
        }
        return omNode != null && 1 == omNode.getType() ? (OMElement)omNode : null;
    }

    @Override
    public void setFirstChild(OMNode firstChild) {
        this.firstChild = firstChild;
    }

    @Override
    public void setLastChild(OMNode omNode) {
        this.lastChild = omNode;
    }

    @Override
    public String getCharsetEncoding() {
        return this.charSetEncoding;
    }

    @Override
    public void setCharsetEncoding(String charEncoding) {
        this.charSetEncoding = charEncoding;
    }

    @Override
    public String isStandalone() {
        return this.isStandalone;
    }

    @Override
    public void setStandalone(String isStandalone) {
        this.isStandalone = isStandalone;
    }

    @Override
    public String getXMLVersion() {
        return this.xmlVersion;
    }

    @Override
    public void setXMLVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    @Override
    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        this.internalSerialize(writer, cache, !((MTOMXMLStreamWriter)writer).isIgnoreXMLDeclaration());
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache, boolean includeXMLDeclaration) throws XMLStreamException {
        OMDocumentImplUtil.internalSerialize(this, writer, cache, includeXMLDeclaration);
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, false);
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, true);
    }

    @Override
    public XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    @Override
    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean cache) {
        return OMContainerHelper.getXMLStreamReader(this, cache);
    }
}

