/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security.authzcache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.service.security.authzcache.AuthzCacheEntry;
import org.apache.airavata.service.security.authzcache.AuthzCacheIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzCache
extends LinkedHashMap<AuthzCacheIndex, AuthzCacheEntry> {
    private static int MAX_SIZE;
    private static final Logger logger;
    private static AuthzCache authzCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthzCache getInstance() throws ApplicationSettingsException {
        if (authzCache != null) return authzCache;
        Class<AuthzCache> clazz = AuthzCache.class;
        synchronized (AuthzCache.class) {
            if (authzCache != null) return authzCache;
            authzCache = new AuthzCache(ServerSettings.getCacheSize());
            // ** MonitorExit[var0] (shouldn't be in output)
            return authzCache;
        }
    }

    private AuthzCache(int initialCapacity) {
        super(initialCapacity);
        MAX_SIZE = initialCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<AuthzCacheIndex, AuthzCacheEntry> eldest) {
        if (this.size() > MAX_SIZE) {
            logger.info("Authz cache max size exceeded. Removing the old entries.");
        }
        return this.size() > MAX_SIZE;
    }

    static {
        logger = LoggerFactory.getLogger(AuthzCache.class);
        authzCache = null;
    }
}

