/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SetQueueAttributesRequestMarshaller
implements Marshaller<Request<SetQueueAttributesRequest>, SetQueueAttributesRequest> {
    public Request<SetQueueAttributesRequest> marshall(SetQueueAttributesRequest setQueueAttributesRequest) {
        if (setQueueAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setQueueAttributesRequest, "AmazonSQS");
        request.addParameter("Action", "SetQueueAttributes");
        request.addParameter("Version", "2012-11-05");
        if (setQueueAttributesRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)setQueueAttributesRequest.getQueueUrl()));
        }
        if (setQueueAttributesRequest != null && setQueueAttributesRequest.getAttributes() != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> attributesListValue : setQueueAttributesRequest.getAttributes().entrySet()) {
                if (attributesListValue.getKey() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString((String)attributesListValue.getKey()));
                }
                if (attributesListValue.getValue() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString((String)attributesListValue.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

