/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.rdbms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.xml.bind.JAXBContext;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.common.spi.DataSourceReader;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSource;
import org.wso2.carbon.utils.CarbonUtils;

public class RDBMSDataSourceReader
implements DataSourceReader {
    public String getType() {
        return "RDBMS";
    }

    public static RDBMSConfiguration loadConfig(String xmlConfiguration) throws DataSourceException {
        try {
            xmlConfiguration = CarbonUtils.replaceSystemVariablesInXml((String)xmlConfiguration);
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RDBMSConfiguration.class});
            return (RDBMSConfiguration)ctx.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlConfiguration.getBytes()));
        }
        catch (Exception e) {
            throw new DataSourceException("Error in loading RDBMS configuration: " + e.getMessage(), e);
        }
    }

    public Object createDataSource(String xmlConfiguration, boolean isDataSourceFactoryReference) throws DataSourceException {
        if (isDataSourceFactoryReference) {
            return new RDBMSDataSource(RDBMSDataSourceReader.loadConfig(xmlConfiguration)).getDataSourceFactoryReference();
        }
        return new RDBMSDataSource(RDBMSDataSourceReader.loadConfig(xmlConfiguration)).getDataSource();
    }

    public boolean testDataSourceConnection(String xmlConfiguration) throws DataSourceException {
        RDBMSConfiguration rdbmsConfiguration = RDBMSDataSourceReader.loadConfig(xmlConfiguration);
        DataSource dataSource = new RDBMSDataSource(rdbmsConfiguration).getDataSource();
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new DataSourceException("Error establishing data source connection: " + e.getMessage(), (Exception)e);
        }
        if (connection != null) {
            String validationQuery = rdbmsConfiguration.getValidationQuery();
            if (validationQuery != null && !"".equals(validationQuery)) {
                PreparedStatement ps = null;
                try {
                    ps = connection.prepareStatement(validationQuery.trim());
                    ps.execute();
                    ps.close();
                }
                catch (SQLException e) {
                    throw new DataSourceException("Error during executing validation query: " + e.getMessage(), (Exception)e);
                }
            }
            try {
                connection.close();
            }
            catch (SQLException ignored) {
                // empty catch block
            }
        }
        return true;
    }
}

