/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.jest.Closure;
import org.apache.openjpa.persistence.jest.MetamodelHelper;
import org.apache.openjpa.persistence.jest.ObjectFormatter;
import org.apache.openjpa.persistence.meta.Members;
import org.apache.openjpa.util.InternalException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLFormatter
implements ObjectFormatter<Document> {
    public static final Schema _xsd;
    private static final DocumentBuilder _builder;
    private static final Transformer _transformer;
    private static final String EMPTY_TEXT = " ";
    protected static Localizer _loc;

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public Document encode(Collection<OpenJPAStateManager> sms, Metamodel model) {
        Element root = this.newDocument("instances");
        Closure closure = new Closure(sms);
        for (OpenJPAStateManager sm : closure) {
            this.encodeManagedInstance(sm, root, false, model);
        }
        return root.getOwnerDocument();
    }

    @Override
    public Document encode(Metamodel model) {
        Element root = this.newDocument("metamodel");
        for (ManagedType<?> t : model.getManagedTypes()) {
            this.encodeManagedType(t, root);
        }
        return root.getOwnerDocument();
    }

    public Element newDocument(String rootTag) {
        Document doc = _builder.newDocument();
        Element root = doc.createElement(rootTag);
        doc.appendChild(root);
        String[] nvpairs = new String[]{"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "version", "1.0"};
        for (int i = 0; i < nvpairs.length; i += 2) {
            root.setAttribute(nvpairs[i], nvpairs[i + 1]);
        }
        return root;
    }

    @Override
    public Document writeOut(Collection<OpenJPAStateManager> objs, Metamodel model, String title, String desc, String uri, OutputStream out) throws IOException {
        Object doc = this.encode((Collection)objs, model);
        this.decorate((Document)doc, title, desc, uri);
        this.write((Document)doc, out);
        return doc;
    }

    @Override
    public Document writeOut(Metamodel model, String title, String desc, String uri, OutputStream out) throws IOException {
        Document doc = this.encode(model);
        this.decorate(doc, title, desc, uri);
        this.write(doc, out);
        return doc;
    }

    Document decorate(Document doc, String title, String desc, String uri) {
        Element root = doc.getDocumentElement();
        Element instance = (Element)root.getElementsByTagName("instance").item(0);
        Element uriElement = doc.createElement("uri");
        uriElement.setTextContent(uri == null ? "null" : uri);
        Element descElement = doc.createElement("description");
        descElement.setTextContent(desc == null ? "null" : desc);
        root.insertBefore(uriElement, instance);
        root.insertBefore(descElement, instance);
        return doc;
    }

    public void write(Document doc, OutputStream out) throws IOException {
        try {
            _transformer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void write(Document doc, Writer writer) throws IOException {
        try {
            _transformer.transform(new DOMSource(doc), new StreamResult(writer));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Element encodeManagedInstance(OpenJPAStateManager sm, Element parent, boolean isRef, Metamodel model) {
        if (parent == null) {
            throw new InternalException(_loc.get("format-xml-null-parent"));
        }
        Document doc = parent.getOwnerDocument();
        if (doc == null) {
            throw new InternalException(_loc.get("format-xml-null-doc"));
        }
        if (sm == null || isRef) {
            return this.encodeRef(parent, sm);
        }
        Element root = doc.createElement("instance");
        parent.appendChild(root);
        root.setAttribute("id", this.ior(sm));
        Element child = null;
        BitSet loaded = sm.getLoaded();
        StoreContext ctx = (StoreContext)sm.getGenericContext();
        List<Attribute<?, ?>> attrs = MetamodelHelper.getAttributesInOrder(sm.getMetaData(), model);
        for (int i = 0; i < attrs.size(); ++i) {
            Members.Member attr = (Members.Member)attrs.get(i);
            FieldMetaData fmd = attr.fmd;
            if (loaded.get(fmd.getIndex())) {
                String tag = MetamodelHelper.getTagByAttributeType(attr);
                List<Object> value = sm.fetch(fmd.getIndex());
                switch (fmd.getDeclaredTypeCode()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 28: 
                    case 32: {
                        child = doc.createElement(tag);
                        child.setAttribute("name", fmd.getName());
                        if (value == null) {
                            this.encodeNull(child);
                            break;
                        }
                        this.encodeBasic(child, value, fmd.getDeclaredType());
                        break;
                    }
                    case 29: {
                        child = doc.createElement("ref");
                        child.setAttribute("name", fmd.getName());
                        if (value == null) {
                            this.encodeNull(child);
                            break;
                        }
                        this.encodeBasic(child, value, fmd.getDeclaredType());
                        break;
                    }
                    case 15: {
                        child = doc.createElement(tag);
                        child.setAttribute("name", fmd.getName());
                        child.setAttribute("type", this.typeOf(fmd));
                        OpenJPAStateManager other = ctx.getStateManager(value);
                        this.encodeManagedInstance(other, child, true, model);
                        break;
                    }
                    case 11: {
                        Object[] values = (Object[])value;
                        value = Arrays.asList(values);
                    }
                    case 12: {
                        child = doc.createElement(tag);
                        child.setAttribute("name", fmd.getName());
                        child.setAttribute("type", this.typeOf(fmd));
                        child.setAttribute("member-type", this.typeOf(fmd.getElement().getDeclaredType()));
                        if (value == null) {
                            this.encodeNull(child);
                            break;
                        }
                        Collection members = value;
                        boolean basic = fmd.getElement().getTypeMetaData() == null;
                        for (Object o : members) {
                            Element member = doc.createElement("member");
                            child.appendChild(member);
                            if (o == null) {
                                this.encodeNull(member);
                                continue;
                            }
                            if (basic) {
                                this.encodeBasic(member, o, o.getClass());
                                continue;
                            }
                            this.encodeManagedInstance(ctx.getStateManager(o), member, true, model);
                        }
                        break;
                    }
                    case 13: {
                        child = doc.createElement(tag);
                        child.setAttribute("name", fmd.getName());
                        child.setAttribute("type", this.typeOf(fmd));
                        child.setAttribute("key-type", this.typeOf(fmd.getElement().getDeclaredType()));
                        child.setAttribute("value-type", this.typeOf(fmd.getValue().getDeclaredType()));
                        if (value == null) {
                            this.encodeNull(child);
                            break;
                        }
                        Set entries = ((Map)((Object)value)).entrySet();
                        boolean basicKey = fmd.getElement().getTypeMetaData() == null;
                        boolean basicValue = fmd.getValue().getTypeMetaData() == null;
                        for (Map.Entry e : entries) {
                            Element entry = doc.createElement("entry");
                            Element entryKey = doc.createElement("key");
                            Element entryValue = doc.createElement("value");
                            entry.appendChild(entryKey);
                            entry.appendChild(entryValue);
                            child.appendChild(entry);
                            if (e.getKey() == null) {
                                this.encodeNull(entryKey);
                            } else if (basicKey) {
                                this.encodeBasic(entryKey, e.getKey(), e.getKey().getClass());
                            } else {
                                this.encodeManagedInstance(ctx.getStateManager(e.getKey()), entryKey, true, model);
                            }
                            if (e.getValue() == null) {
                                this.encodeNull(entryValue);
                                continue;
                            }
                            if (basicValue) {
                                this.encodeBasic(entryValue, e.getValue(), e.getValue().getClass());
                                continue;
                            }
                            this.encodeManagedInstance(ctx.getStateManager(e.getValue()), entryValue, true, model);
                        }
                        break;
                    }
                    case 30: 
                    case 31: {
                        child = doc.createElement(tag);
                        child.setAttribute("name", fmd.getName());
                        child.setAttribute("type", this.typeOf(fmd));
                        if (value == null) {
                            this.encodeNull(child);
                            break;
                        }
                        CDATASection data = doc.createCDATASection(this.streamToString(value));
                        child.appendChild(data);
                        break;
                    }
                    case 8: 
                    case 27: {
                        System.err.println("Not handled " + fmd.getName() + " of type " + fmd.getDeclaredType());
                    }
                }
                if (child != null) {
                    root.appendChild(child);
                }
            }
            child = null;
        }
        return root;
    }

    private void encodeNull(Element element) {
        element.setAttribute("null", "true");
    }

    private Element encodeRef(Element parent, OpenJPAStateManager sm) {
        Element ref = parent.getOwnerDocument().createElement(sm == null ? "null" : "ref");
        if (sm != null) {
            ref.setAttribute("id", this.ior(sm));
        }
        ref.setTextContent(EMPTY_TEXT);
        parent.appendChild(ref);
        return ref;
    }

    private void encodeBasic(Element element, Object obj, Class<?> runtimeType) {
        element.setAttribute("type", this.typeOf(runtimeType));
        if (obj instanceof Date) {
            element.setTextContent(dateFormat.format(obj));
        } else {
            element.setTextContent(obj == null ? "null" : obj.toString());
        }
    }

    private String streamToString(Object value) {
        Reader reader = null;
        if (value instanceof InputStream) {
            reader = new BufferedReader(new InputStreamReader((InputStream)value));
        } else if (value instanceof Reader) {
            reader = (Reader)value;
        } else {
            throw new RuntimeException();
        }
        CharArrayWriter writer = new CharArrayWriter();
        try {
            int c;
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return writer.toString();
    }

    private void encodeManagedType(ManagedType<?> type, Element parent) {
        Document doc = parent.getOwnerDocument();
        Element root = doc.createElement(type.getPersistenceType().toString().toLowerCase());
        parent.appendChild(root);
        root.setAttribute("name", type.getJavaType().getSimpleName());
        List<Attribute<?, ?>> attributes = MetamodelHelper.getAttributesInOrder(type);
        for (Attribute<?, ?> a : attributes) {
            String tag = MetamodelHelper.getTagByAttributeType(a);
            Element child = doc.createElement(tag);
            root.appendChild(child);
            child.setAttribute("type", this.typeOf(a.getJavaType()));
            if (a instanceof PluralAttribute) {
                if (a instanceof MapAttribute) {
                    child.setAttribute("key-type", this.typeOf(((MapAttribute)a).getKeyJavaType()));
                    child.setAttribute("value-type", this.typeOf(((MapAttribute)a).getBindableJavaType()));
                } else {
                    child.setAttribute("member-type", this.typeOf(((PluralAttribute)a).getBindableJavaType()));
                }
            }
            child.setTextContent(a.getName());
        }
    }

    void validate(Document doc) throws Exception {
        Validator validator = _xsd.newValidator();
        validator.validate(new DOMSource(doc));
    }

    String ior(OpenJPAStateManager sm) {
        return this.typeOf(sm) + "-" + sm.getObjectId();
    }

    String typeOf(OpenJPAStateManager sm) {
        return sm.getMetaData().getDescribedType().getSimpleName();
    }

    String typeOf(Class<?> cls) {
        return cls.getSimpleName();
    }

    String typeOf(ClassMetaData meta) {
        return meta.getDescribedType().getSimpleName();
    }

    String typeOf(ValueMetaData vm) {
        if (vm.getTypeMetaData() == null) {
            return this.typeOf(vm.getType());
        }
        return this.typeOf(vm.getTypeMetaData());
    }

    String typeOf(FieldMetaData fmd) {
        return fmd.getType().getSimpleName();
    }

    static {
        _loc = Localizer.forPackage(XMLFormatter.class);
        try {
            _builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            _transformer = TransformerFactory.newInstance().newTransformer();
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            InputStream xsd = XMLFormatter.class.getResourceAsStream("jest-instance.xsd");
            _xsd = factory.newSchema(new StreamSource(xsd));
            _transformer.setOutputProperty("method", "xml");
            _transformer.setOutputProperty("omit-xml-declaration", "no");
            _transformer.setOutputProperty("indent", "yes");
            _transformer.setOutputProperty("standalone", "no");
            _transformer.setOutputProperty("encoding", "UTF-8");
            _transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

