/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault;

import java.security.Key;
import org.wso2.securevault.AsymmetricCipher;
import org.wso2.securevault.BaseCipher;
import org.wso2.securevault.SymmetricCipher;
import org.wso2.securevault.definition.CipherInformation;
import org.wso2.securevault.definition.KeyStoreInformation;
import org.wso2.securevault.keystore.KeyStoreWrapper;

public class CipherFactory {
    public static BaseCipher createCipher(CipherInformation cipherInformation, KeyStoreInformation keystoreInformation) {
        if ("symmetric".equals(cipherInformation.getType())) {
            return new SymmetricCipher(cipherInformation, keystoreInformation);
        }
        return new AsymmetricCipher(cipherInformation, keystoreInformation);
    }

    public static BaseCipher createCipher(CipherInformation cipherInformation, KeyStoreWrapper keyStoreWrapper) {
        if ("symmetric".equals(cipherInformation.getType())) {
            return new SymmetricCipher(cipherInformation, keyStoreWrapper);
        }
        return new AsymmetricCipher(cipherInformation, keyStoreWrapper);
    }

    public static BaseCipher createCipher(CipherInformation cipherInformation, Key key) {
        if ("symmetric".equals(cipherInformation.getType())) {
            return new SymmetricCipher(cipherInformation, key);
        }
        return new AsymmetricCipher(cipherInformation, key);
    }
}

