/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.globus.gsi.X509ExtensionSet;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.proxy.ext.GlobusProxyCertInfoExtension;
import org.globus.gsi.proxy.ext.ProxyCertInfoExtension;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.ProxyCertificateUtil;
import org.globus.tools.ProxyInit;
import org.globus.util.Util;

class DefaultProxyInit
extends ProxyInit {
    private PrivateKey userKey = null;

    DefaultProxyInit() {
    }

    public void init(String[] args) {
        DefaultProxyInit.verify(args[1], "User key");
        DefaultProxyInit.verify(args[0], "User certificate");
    }

    public void verify() throws Exception {
        RSAPublicKey pkey = (RSAPublicKey)this.getCertificate().getPublicKey();
        RSAPrivateKey prkey = (RSAPrivateKey)this.userKey;
        if (!pkey.getModulus().equals(prkey.getModulus())) {
            throw new Exception("Certificate and private key specified do not match");
        }
        super.verify();
    }

    private static void verify(String file, String msg) {
        File f;
        if (file == null) {
            DefaultProxyInit.error(msg + " not specified.");
        }
        if (!(f = new File(file)).exists() || f.isDirectory()) {
            DefaultProxyInit.error(msg + " not found.");
        }
    }

    public void loadCertificates(String arg) {
        try {
            this.certificates = CertificateLoadUtil.loadCertificates(arg);
        }
        catch (IOException e) {
            System.err.println("Error: Failed to load cert: " + arg);
            System.exit(-1);
        }
        catch (GeneralSecurityException e) {
            System.err.println("Error: Unable to load user certificate: " + e.getMessage());
            System.exit(-1);
        }
    }

    public void loadKey(String arg) {
        try {
            BouncyCastleOpenSSLKey key = new BouncyCastleOpenSSLKey(arg);
            if (key.isEncrypted()) {
                String pwd;
                String prompt = this.quiet ? "Enter GRID pass phrase: " : "Enter GRID pass phrase for this identity: ";
                String string = pwd = this.stdin ? Util.getInput(prompt) : Util.getPrivateInput(prompt);
                if (pwd == null) {
                    System.exit(1);
                }
                key.decrypt(pwd);
            }
            this.userKey = key.getPrivateKey();
        }
        catch (IOException e) {
            System.err.println("Error: Failed to load key: " + arg);
            System.err.println("Error: " + e.getMessage());
            System.exit(-1);
        }
        catch (GeneralSecurityException e) {
            System.err.println("Error: Wrong pass phrase");
            System.err.println("Error: " + e.getMessage());
            if (this.debug) {
                e.printStackTrace();
            }
            System.exit(-1);
        }
    }

    public void sign() {
        try {
            BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
            X509ExtensionSet extSet = null;
            if (this.proxyCertInfo != null) {
                extSet = new X509ExtensionSet();
                if (ProxyCertificateUtil.isGsi4Proxy(this.proxyType)) {
                    extSet.add(new ProxyCertInfoExtension(this.proxyCertInfo));
                } else {
                    extSet.add(new GlobusProxyCertInfoExtension(this.proxyCertInfo));
                }
            }
            this.proxy = factory.createCredential(this.certificates, this.userKey, this.bits, this.lifetime, this.proxyType.getCode(), extSet);
        }
        catch (GeneralSecurityException e) {
            System.err.println("Failed to create a proxy: " + e.getMessage());
            System.exit(-1);
        }
    }
}

