/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.sql.dictionary.ConsInfo;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class ConstraintInfo
implements ConsInfo {
    private String tableName;
    private SchemaDescriptor tableSd;
    private UUID tableSchemaId;
    private String[] columnNames;
    private int raDeleteRule;
    private int raUpdateRule;

    public ConstraintInfo() {
    }

    public ConstraintInfo(String string, SchemaDescriptor schemaDescriptor, String[] stringArray, int n, int n2) {
        this.tableName = string;
        this.tableSd = schemaDescriptor;
        this.columnNames = ArrayUtil.copy(stringArray);
        this.raDeleteRule = n;
        this.raUpdateRule = n2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.tableName);
        if (this.tableSd == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(this.tableSd.getUUID());
        }
        if (this.columnNames == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            ArrayUtil.writeArrayLength(objectOutput, this.columnNames);
            ArrayUtil.writeArrayItems(objectOutput, this.columnNames);
        }
        objectOutput.writeInt(this.raDeleteRule);
        objectOutput.writeInt(this.raUpdateRule);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.tableName = (String)objectInput.readObject();
        if (objectInput.readBoolean()) {
            this.tableSchemaId = (UUID)objectInput.readObject();
        }
        if (objectInput.readBoolean()) {
            this.columnNames = new String[ArrayUtil.readArrayLength(objectInput)];
            ArrayUtil.readArrayItems(objectInput, this.columnNames);
        }
        this.raDeleteRule = objectInput.readInt();
        this.raUpdateRule = objectInput.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 278;
    }

    public String toString() {
        return "";
    }

    @Override
    public SchemaDescriptor getReferencedTableSchemaDescriptor(DataDictionary dataDictionary) throws StandardException {
        if (this.tableSd != null) {
            return this.tableSd;
        }
        return dataDictionary.getSchemaDescriptor(this.tableSchemaId, null);
    }

    @Override
    public TableDescriptor getReferencedTableDescriptor(DataDictionary dataDictionary) throws StandardException {
        if (this.tableName == null) {
            return null;
        }
        return dataDictionary.getTableDescriptor(this.tableName, this.getReferencedTableSchemaDescriptor(dataDictionary), null);
    }

    @Override
    public String[] getReferencedColumnNames() {
        return ArrayUtil.copy(this.columnNames);
    }

    @Override
    public String getReferencedTableName() {
        return this.tableName;
    }

    @Override
    public int getReferentialActionUpdateRule() {
        return this.raUpdateRule;
    }

    @Override
    public int getReferentialActionDeleteRule() {
        return this.raDeleteRule;
    }
}

