/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dataaccess;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSource;
import org.wso2.carbon.registry.core.config.DataBaseConfiguration;
import org.wso2.carbon.registry.core.dataaccess.ClusterLock;
import org.wso2.carbon.registry.core.dataaccess.DAOManager;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.dataaccess.DatabaseTransaction;
import org.wso2.carbon.registry.core.dataaccess.QueryProcessor;
import org.wso2.carbon.registry.core.dataaccess.TransactionManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCClusterLock;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDAOManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCTransactionManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.SQLQueryProcessor;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class JDBCDataAccessManager
implements DataAccessManager {
    private static final Log log = LogFactory.getLog(JDBCDataAccessManager.class);
    private DataSource dataSource;
    private static ClusterLock clusterLock = new JDBCClusterLock();
    private static DatabaseTransaction databaseTransaction = new JDBCDatabaseTransaction();
    private static DAOManager daoManager = new JDBCDAOManager();
    private static Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

    public JDBCDataAccessManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JDBCDataAccessManager(DataBaseConfiguration dataBaseConfiguration) {
        String dataSourceName = dataBaseConfiguration.getDataSourceName();
        if (dataSourceName != null) {
            try {
                this.dataSource = dataSources.get(dataSourceName);
                if (this.dataSource == null) {
                    InitialContext context = new InitialContext();
                    this.dataSource = (DataSource)context.lookup(dataSourceName);
                    dataSources.put(dataSourceName, this.dataSource);
                }
            }
            catch (NamingException e) {
                log.error((Object)("Couldn't find dataSource '" + dataSourceName + "'"), (Throwable)e);
            }
        } else {
            String configName = dataBaseConfiguration.getConfigName();
            this.dataSource = dataSources.get(configName);
            if (this.dataSource == null) {
                this.dataSource = JDBCDataAccessManager.buildDataSource(dataBaseConfiguration);
                dataSources.put(configName, this.dataSource);
            }
        }
    }

    @Override
    public ClusterLock getClusterLock() {
        return clusterLock;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return new JDBCTransactionManager(this);
    }

    @Override
    public DatabaseTransaction getDatabaseTransaction() {
        return databaseTransaction;
    }

    @Override
    public QueryProcessor getQueryProcessor() {
        return new SQLQueryProcessor(this);
    }

    @Override
    public DAOManager getDAOManager() {
        return daoManager;
    }

    @Override
    public void createDatabase() throws RegistryException {
        DatabaseCreator databaseCreator = new DatabaseCreator(this.getDataSource());
        try {
            databaseCreator.createRegistryDatabase();
        }
        catch (Exception e) {
            String msg = "Error in creating the database";
            throw new RegistryException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDatabaseExisting() {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Running a query to test the database tables existence.");
            }
            Connection conn = this.dataSource.getConnection();
            String sql = "SELECT REG_PATH_ID FROM REG_PATH WHERE REG_PATH_VALUE='/'";
            Statement statement = null;
            try {
                statement = conn.createStatement();
                ResultSet rs = statement.executeQuery(sql);
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static DataSource buildDataSource(DataBaseConfiguration config) {
        RDBMSConfiguration dsConf = new RDBMSConfiguration();
        dsConf.setUrl(config.getDbUrl());
        dsConf.setDriverClassName(config.getDriverName());
        dsConf.setUsername(config.getUserName());
        dsConf.setPassword(config.getResolvedPassword());
        if (config.getTestWhileIdle() != null) {
            dsConf.setTestWhileIdle(Boolean.valueOf(Boolean.parseBoolean(config.getTestWhileIdle())));
        }
        if (config.getTimeBetweenEvictionRunsMillis() != null) {
            dsConf.setTimeBetweenEvictionRunsMillis(Integer.valueOf(Integer.parseInt(config.getTimeBetweenEvictionRunsMillis())));
        }
        if (config.getMinEvictableIdleTimeMillis() != null) {
            dsConf.setMinEvictableIdleTimeMillis(Integer.valueOf(Integer.parseInt(config.getMinEvictableIdleTimeMillis())));
        }
        if (config.getNumTestsPerEvictionRun() != null) {
            dsConf.setNumTestsPerEvictionRun(Integer.valueOf(Integer.parseInt(config.getNumTestsPerEvictionRun())));
        }
        if (config.getMaxActive() != null) {
            dsConf.setMaxActive(Integer.valueOf(Integer.parseInt(config.getMaxActive())));
        } else {
            dsConf.setMaxActive(Integer.valueOf(40));
        }
        if (config.getMaxWait() != null) {
            dsConf.setMaxWait(Integer.valueOf(Integer.parseInt(config.getMaxWait())));
        } else {
            dsConf.setMaxWait(Integer.valueOf(60000));
        }
        if (config.getMaxIdle() != null) {
            dsConf.setMaxIdle(Integer.valueOf(Integer.parseInt(config.getMaxIdle())));
        }
        if (config.getMinIdle() != null) {
            dsConf.setMinIdle(Integer.valueOf(Integer.parseInt(config.getMinIdle())));
        } else {
            dsConf.setMinIdle(Integer.valueOf(5));
        }
        if (config.getValidationQuery() != null) {
            dsConf.setValidationQuery(config.getValidationQuery());
        }
        try {
            return new RDBMSDataSource(dsConf).getDataSource();
        }
        catch (Exception e) {
            throw new RuntimeException("Error in creating data source for the registry: " + e.getMessage(), e);
        }
    }
}

