/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.CarbonUtils;

public final class ServiceConfigUtil {
    private static final Log log = LogFactory.getLog(ServiceConfigUtil.class);

    private ServiceConfigUtil() {
    }

    public static String getConfigFile() throws RegistryException {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome != null) {
            Object omElement = null;
            String configPath = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "services-config.xml";
            try {
                File configFile = new File(configPath);
                if (configFile.exists()) {
                    FileInputStream stream = new FileInputStream(configFile);
                    StAXOMBuilder builder = new StAXOMBuilder((InputStream)stream);
                    omElement = builder.getDocumentElement();
                }
            }
            catch (FileNotFoundException e) {
                log.error((Object)("The services configuration file was not found at: " + configPath));
            }
            catch (XMLStreamException e) {
                log.error((Object)"The configuration file does not contain well formed XML", (Throwable)e);
            }
            return omElement != null ? omElement.toString() : null;
        }
        String msg = "carbon.home system property is not set. It is required to to derive the path of the Services configuration file (services-config.xml).";
        log.error((Object)msg);
        throw new RegistryException(msg);
    }

    public static void addConfig(Registry registry) throws Exception {
        ResourceImpl config = new ResourceImpl();
        String path = "/_system/config/repository/components/org.wso2.carbon.governance/configuration/services/service";
        if (RegistryUtils.systemResourceShouldBeAdded(registry, path)) {
            if (registry.getRegistryContext() != null && registry.getRegistryContext().isClone()) {
                return;
            }
            String serviceConfig = ServiceConfigUtil.getConfigFile();
            if (serviceConfig != null) {
                config.setContent(RegistryUtils.encodeString(serviceConfig));
            }
            registry.put(path, config);
        }
    }

    public static void addConfigSchema(Registry registry) throws Exception {
        ResourceImpl config = new ResourceImpl();
        String path = "/_system/config/repository/components/org.wso2.carbon.governance/configuration/services/service-schema";
        if (RegistryUtils.systemResourceShouldBeAdded(registry, path)) {
            if (registry.getRegistryContext() != null && registry.getRegistryContext().isClone()) {
                return;
            }
            String serviceConfig = ServiceConfigUtil.getConfigSchemaFile();
            if (serviceConfig != null) {
                config.setContent(RegistryUtils.encodeString(serviceConfig));
            }
            registry.put(path, config);
        }
    }

    public static String getConfigSchemaFile() throws RegistryException {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome != null) {
            Object omElement = null;
            String configPath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "services-config.xsd";
            try {
                File configFile = new File(configPath);
                if (configFile.exists()) {
                    FileInputStream stream = new FileInputStream(configFile);
                    StAXOMBuilder builder = new StAXOMBuilder((InputStream)stream);
                    omElement = builder.getDocumentElement();
                }
            }
            catch (FileNotFoundException e) {
                log.error((Object)("The services configuration schema file was not found at: " + configPath));
            }
            catch (XMLStreamException e) {
                log.error((Object)"The configuration schema file does not contain well formed XML", (Throwable)e);
            }
            return omElement != null ? omElement.toString() : null;
        }
        String msg = "carbon.home system property is not set. It is required to to derive the path of the Services configuration file (services-config.xml).";
        log.error((Object)msg);
        throw new RegistryException(msg);
    }
}

