/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.dpc.AuthorizationCheck;
import eu.unicore.uftp.dpc.AuthorizationFailureException;
import eu.unicore.uftp.dpc.DPCServer;
import eu.unicore.uftp.dpc.ProtocolViolationException;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.server.DefaultFileAccess;
import eu.unicore.uftp.server.FileAccess;
import eu.unicore.uftp.server.SetUIDFileAccess;
import eu.unicore.uftp.server.UFTPTransferRequest;
import eu.unicore.uftp.server.UFTPWorker;
import eu.unicore.uftp.server.unix.UnixUser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ServerThread
extends Thread
implements AuthorizationCheck {
    private static final Logger logger = Logger.getLogger(ServerThread.class);
    private final DPCServer server;
    private final Map<InetAddress, List<UFTPTransferRequest>> jobMap;
    private final Map<InetAddress, AtomicInteger> runningConnectionsMap;
    private final FileAccess fileAccess;
    private final boolean haveUnixUser;
    private volatile boolean isHalt = false;
    private final ScheduledExecutorService executor;
    public static final long MAX_JOB_AGE_DEFAULT = 600000L;
    public final long maxJobAge;
    private int maxStreams;
    private int maxControlConnectionsPerClient = 128;
    private int bufferSize = 131072;

    public ServerThread(InetAddress ip, int port, int backlog, int maxStreams) throws IOException {
        this.server = new DPCServer(ip, port, backlog, this);
        this.maxStreams = maxStreams;
        this.jobMap = new ConcurrentHashMap<InetAddress, List<UFTPTransferRequest>>();
        this.runningConnectionsMap = new ConcurrentHashMap<InetAddress, AtomicInteger>();
        this.executor = Utils.getExecutor();
        this.setupExpiryCheck();
        this.maxJobAge = Integer.parseInt(System.getProperty("uftpd.maxJobAge", "600000"));
        logger.info("Limiting request lifetime to " + this.maxJobAge + " ms.");
        this.fileAccess = this.initFileAccess();
        this.haveUnixUser = this.fileAccess instanceof SetUIDFileAccess;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (!this.isHalt) {
                try {
                    final DPCServer.Connection connection = this.server.accept();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ServerThread.this.processConnection(connection, ServerThread.this.maxStreams);
                        }
                    };
                    this.executor.execute(r);
                }
                catch (SocketTimeoutException ste) {
                }
                catch (IOException e) {
                    if (!(e instanceof SocketException)) continue;
                    throw (SocketException)e;
                    return;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnection(DPCServer.Connection connection, int maxStreams) {
        InetAddress client = connection.getAddress();
        try {
            AtomicInteger counter;
            List<UFTPTransferRequest> jobs = this.jobMap.get(client);
            if (jobs == null || jobs.isEmpty()) {
                logger.info("Rejecting connection from " + client + " : no valid job for that client address.");
                connection.close();
                return;
            }
            UFTPTransferRequest job = (UFTPTransferRequest)connection.establish();
            jobs.remove(job);
            if (jobs.isEmpty()) {
                this.jobMap.remove(connection.getAddress());
            }
            Map<InetAddress, AtomicInteger> map = this.runningConnectionsMap;
            synchronized (map) {
                counter = this.runningConnectionsMap.get(client);
                if (counter == null) {
                    counter = new AtomicInteger();
                }
                this.runningConnectionsMap.put(client, counter);
            }
            if (counter.incrementAndGet() == this.maxControlConnectionsPerClient) {
                logger.info("Rejecting connection from " + client + " : too many connections for that client .");
                return;
            }
            new UFTPWorker(this, connection, job, maxStreams, this.bufferSize).start();
        }
        catch (ProtocolViolationException e) {
            logger.info("Rejecting connection attempt from " + client + ": protocol violation.", e);
        }
        catch (AuthorizationFailureException e) {
            logger.info("Rejecting connection attempt from " + client + ": authorization failed.", e);
        }
        catch (Exception ex) {
            logger.info("Unkown Error occured", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UFTPTransferRequest findJob(List<UFTPTransferRequest> jobs, String id) {
        List<UFTPTransferRequest> list = jobs;
        synchronized (list) {
            for (UFTPTransferRequest j : jobs) {
                if (!id.equals(j.getSecret())) continue;
                return j;
            }
        }
        return null;
    }

    public void addJob(UFTPTransferRequest job) {
        List<UFTPTransferRequest> jobs;
        if (this.haveUnixUser) {
            UnixUser user = new UnixUser(job.getUser());
            logger.debug("Have Unix user: " + user.toString());
        }
        if ((jobs = this.jobMap.get(job.getClient())) == null) {
            jobs = Collections.synchronizedList(new ArrayList());
            this.jobMap.put(job.getClient(), jobs);
        }
        jobs.add(job);
    }

    public void close() throws IOException {
        logger.info("Closing UFTPD server");
        this.halt();
        this.server.close();
        this.executor.shutdownNow();
    }

    public void setTimeout(int time) {
        this.server.setTimeout(time);
    }

    public int getTimeout() {
        return this.server.getTimeout();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void setAuthTimeout(int time) {
        this.server.setAuthTimeout(time);
    }

    public int getAuthTimeout() {
        return this.server.getAuthTimeout();
    }

    public int getMaxControlConnectionsPerClient() {
        return this.maxControlConnectionsPerClient;
    }

    public void setMaxControlConnectionsPerClient(int maxControlConnectionsPerClient) {
        this.maxControlConnectionsPerClient = maxControlConnectionsPerClient;
    }

    public void setMaxStreamsPerConnection(int maxStreams) {
        if (maxStreams < 1) {
            throw new IllegalArgumentException("Maximum streams per connection must be >=1, got: " + maxStreams);
        }
        this.maxStreams = maxStreams;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be >=1, got: " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    @Override
    public UFTPTransferRequest isAuthorized(Socket authSocket) {
        List<UFTPTransferRequest> jobs = this.jobMap.get(authSocket.getInetAddress());
        if (jobs == null || jobs.isEmpty()) {
            return null;
        }
        try {
            String secret = new BufferedReader(new InputStreamReader(authSocket.getInputStream())).readLine();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(authSocket.getOutputStream()));
            UFTPTransferRequest job = this.findJob(jobs, secret);
            if ("null".equals(secret)) {
                logger.warn("Got 'null' secret, this can potentially lead to user data corruption or loss, please notify user at <" + authSocket.getInetAddress() + "> to update their client!\n");
            }
            if (job != null) {
                bw.write("Authorization OK");
                bw.flush();
                return job;
            }
            bw.write("Authorization FAILED: No matching request found.\n");
            bw.flush();
            return null;
        }
        catch (IOException e) {
            logger.warn("IOException: " + e.getMessage() + " when authorising " + authSocket.getInetAddress());
            return null;
        }
    }

    public void notifyConnectionClosed(InetAddress client) {
        AtomicInteger i = this.runningConnectionsMap.get(client);
        if (i != null) {
            i.decrementAndGet();
        }
    }

    public void halt() {
        this.isHalt = true;
    }

    private final void setupExpiryCheck() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ServerThread.this.checkForExpiredJobs();
            }
        };
        this.executor.scheduleWithFixedDelay(r, 3000L, 10000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForExpiredJobs() {
        for (Map.Entry<InetAddress, List<UFTPTransferRequest>> entry : this.jobMap.entrySet()) {
            List<UFTPTransferRequest> jobs;
            List<UFTPTransferRequest> list = jobs = entry.getValue();
            synchronized (list) {
                Iterator<UFTPTransferRequest> jobIterator = jobs.iterator();
                while (jobIterator.hasNext()) {
                    UFTPTransferRequest job = jobIterator.next();
                    long age = System.currentTimeMillis() - job.getCreatedTime();
                    if (age <= this.maxJobAge) continue;
                    logger.info("Removing expired job from " + job.getUser() + " @ " + job.getClient().getHostAddress());
                    jobIterator.remove();
                }
            }
        }
    }

    public void cleanConnectionCounters() {
        Iterator<Map.Entry<InetAddress, AtomicInteger>> iterator = this.runningConnectionsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<InetAddress, AtomicInteger> entry = iterator.next();
            AtomicInteger counter = entry.getValue();
            if (counter.get() != 0) continue;
            iterator.remove();
        }
    }

    public FileAccess getFileAccess() {
        return this.fileAccess;
    }

    private FileAccess initFileAccess() {
        FileAccess fa = null;
        try {
            fa = new SetUIDFileAccess();
            logger.info("Will switch user IDs");
        }
        catch (UnsatisfiedLinkError ex) {
            logger.warn("Can't load native library for setuid switching, falling back to default mode: " + ex);
        }
        catch (Exception e) {
            logger.warn("Error loading setuid switcher, falling back to default mode: " + e);
        }
        if (fa == null) {
            fa = new DefaultFileAccess();
            logger.info("NOT switching user IDs, will access all files as user <" + System.getProperty("user.name") + ">");
        }
        return fa;
    }
}

