/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.xml.sax.InputSource;

public abstract class AbstractOMMetaFactory
implements OMMetaFactory {
    private XMLStreamReader createXMLStreamReader(StAXParserConfiguration configuration, InputSource is) {
        try {
            if (is.getByteStream() != null) {
                String encoding = is.getEncoding();
                if (encoding == null) {
                    return StAXUtils.createXMLStreamReader(configuration, is.getByteStream());
                }
                return StAXUtils.createXMLStreamReader(configuration, is.getByteStream(), encoding);
            }
            if (is.getCharacterStream() != null) {
                return StAXUtils.createXMLStreamReader(configuration, is.getCharacterStream());
            }
            throw new IllegalArgumentException();
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
    }

    public OMXMLParserWrapper createStAXOMBuilder(OMFactory omFactory, XMLStreamReader parser) {
        StAXOMBuilder builder = new StAXOMBuilder(omFactory, parser);
        builder.releaseParserOnClose(true);
        return builder;
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, StAXParserConfiguration configuration, InputSource is) {
        return this.createStAXOMBuilder(omFactory, this.createXMLStreamReader(configuration, is));
    }

    public OMXMLParserWrapper createStAXSOAPModelBuilder(XMLStreamReader parser) {
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(this, parser);
        builder.releaseParserOnClose(true);
        return builder;
    }

    public OMXMLParserWrapper createSOAPModelBuilder(StAXParserConfiguration configuration, InputSource is) {
        return this.createStAXSOAPModelBuilder(this.createXMLStreamReader(configuration, is));
    }
}

