/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResource;
import org.apache.airavata.registry.core.app.catalog.model.JobSubmissionInterface;
import org.apache.airavata.registry.core.app.catalog.model.JobSubmissionInterface_PK;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSubmissionInterfaceResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(JobSubmissionInterfaceResource.class);
    private String jobSubmissionInterfaceId;
    private String computeResourceId;
    private ComputeResourceResource computeHostResource;
    private String jobSubmissionProtocol;
    private int priorityOrder;
    private Timestamp createdTime;
    private Timestamp updatedTime;

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("JobSubmissionInterface", new Object[0][]);
            generator.setParameter("jobSubmissionInterfaceId", ids.get("jobSubmissionInterfaceId"));
            generator.setParameter("computeResourceId", ids.get("computeResourceId"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("JobSubmissionInterface", new Object[0][]);
            generator.setParameter("jobSubmissionInterfaceId", ids.get("jobSubmissionInterfaceId"));
            generator.setParameter("computeResourceId", ids.get("computeResourceId"));
            Query q = generator.selectQuery(em);
            JobSubmissionInterface jobSubmissionInterface = (JobSubmissionInterface)q.getSingleResult();
            JobSubmissionInterfaceResource jobSubmissionInterfaceResource = (JobSubmissionInterfaceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.JOB_SUBMISSION_INTERFACE, jobSubmissionInterface);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            JobSubmissionInterfaceResource jobSubmissionInterfaceResource2 = jobSubmissionInterfaceResource;
            return jobSubmissionInterfaceResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> jobSubmissionInterfaceResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("JobSubmissionInterface", new Object[0][]);
            if (fieldName.equals("jobSubmissionInterfaceId") || fieldName.equals("computeResourceId") || fieldName.equals("jobSubmissionProtocol") || fieldName.equals("priorityOrder")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    JobSubmissionInterface jobSubmissionInterface = (JobSubmissionInterface)result;
                    JobSubmissionInterfaceResource jobSubmissionInterfaceResource = (JobSubmissionInterfaceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.JOB_SUBMISSION_INTERFACE, jobSubmissionInterface);
                    jobSubmissionInterfaceResources.add(jobSubmissionInterfaceResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Job Submission Interface Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Job Submission Interface Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return jobSubmissionInterfaceResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> jobSubmissionInterfaceResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("JobSubmissionInterface", new Object[0][]);
            if (fieldName.equals("jobSubmissionInterfaceId") || fieldName.equals("computeResourceId") || fieldName.equals("jobSubmissionProtocol") || fieldName.equals("priorityOrder")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    JobSubmissionInterface jobSubmissionInterface = (JobSubmissionInterface)result;
                    JobSubmissionInterfaceResource jobSubmissionInterfaceResource = (JobSubmissionInterfaceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.JOB_SUBMISSION_INTERFACE, jobSubmissionInterface);
                    jobSubmissionInterfaceResourceIDs.add(jobSubmissionInterfaceResource.getComputeResourceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Job Submission Interface Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Job Submission Interface Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return jobSubmissionInterfaceResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            JobSubmissionInterface jobSubmissionInterface;
            em = AppCatalogJPAUtils.getEntityManager();
            JobSubmissionInterface existingJobSubmissionInterface = (JobSubmissionInterface)em.find(JobSubmissionInterface.class, (Object)new JobSubmissionInterface_PK(this.jobSubmissionInterfaceId, this.computeResourceId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingJobSubmissionInterface == null) {
                jobSubmissionInterface = new JobSubmissionInterface();
                jobSubmissionInterface.setCreationTime(AiravataUtils.getCurrentTimestamp());
            } else {
                jobSubmissionInterface = existingJobSubmissionInterface;
                jobSubmissionInterface.setUpdateTime(AiravataUtils.getCurrentTimestamp());
            }
            jobSubmissionInterface.setJobSubmissionInterfaceId(this.getJobSubmissionInterfaceId());
            jobSubmissionInterface.setComputeResourceId(this.getComputeResourceId());
            ComputeResource computeResource = (ComputeResource)em.find(ComputeResource.class, (Object)this.getComputeResourceId());
            jobSubmissionInterface.setComputeResource(computeResource);
            jobSubmissionInterface.setJobSubmissionProtocol(this.getJobSubmissionProtocol());
            jobSubmissionInterface.setPriorityOrder(this.getPriorityOrder());
            if (existingJobSubmissionInterface == null) {
                em.persist((Object)jobSubmissionInterface);
            } else {
                em.merge((Object)jobSubmissionInterface);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            JobSubmissionInterface jobSubmissionInterface = (JobSubmissionInterface)em.find(JobSubmissionInterface.class, (Object)new JobSubmissionInterface_PK((String)ids.get("jobSubmissionInterfaceId"), (String)ids.get("computeResourceId")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = jobSubmissionInterface != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getJobSubmissionInterfaceId() {
        return this.jobSubmissionInterfaceId;
    }

    public String getComputeResourceId() {
        return this.computeResourceId;
    }

    public ComputeResourceResource getComputeHostResource() {
        return this.computeHostResource;
    }

    public String getJobSubmissionProtocol() {
        return this.jobSubmissionProtocol;
    }

    public int getPriorityOrder() {
        return this.priorityOrder;
    }

    public void setJobSubmissionInterfaceId(String jobSubmissionInterfaceId) {
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
    }

    public void setComputeResourceId(String computeResourceId) {
        this.computeResourceId = computeResourceId;
    }

    public void setComputeHostResource(ComputeResourceResource computeHostResource) {
        this.computeHostResource = computeHostResource;
    }

    public void setJobSubmissionProtocol(String jobSubmissionProtocol) {
        this.jobSubmissionProtocol = jobSubmissionProtocol;
    }

    public void setPriorityOrder(int priorityOrder) {
        this.priorityOrder = priorityOrder;
    }
}

