/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.proxy;

import eu.emi.security.authn.x509.helpers.proxy.ExtendedProxyType;
import eu.emi.security.authn.x509.helpers.proxy.IPAddressHelper;
import eu.emi.security.authn.x509.helpers.proxy.ProxyACExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyAddressRestrictionData;
import eu.emi.security.authn.x509.helpers.proxy.ProxyCertInfoExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyHelper;
import eu.emi.security.authn.x509.helpers.proxy.ProxySAMLExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyTracingExtension;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.proxy.ProxyChainType;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.x509.AttributeCertificate;

public class ProxyChainInfo {
    private X509Certificate[] chain;
    private int firstProxy;
    private ProxyChainType type;
    private ProxyPolicy[] policy;
    private Boolean limited;

    public ProxyChainInfo(X509Certificate[] chain) throws CertificateException {
        int i;
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("Certificate chain passed may not be null or empty");
        }
        for (i = chain.length - 1; i >= 0; --i) {
            if (!ProxyUtils.isProxy(chain[i])) continue;
            this.firstProxy = i;
            this.chain = chain;
            break;
        }
        if (i == -1) {
            throw new CertificateException("There is no proxy certificate in the chain");
        }
    }

    public BigInteger[] getSerialNumbers() {
        BigInteger[] ret = new BigInteger[this.chain.length];
        for (int i = 0; i < this.chain.length; ++i) {
            ret[i] = this.chain[i].getSerialNumber();
        }
        return ret;
    }

    public ProxyChainType getProxyType() throws CertificateException {
        if (this.type != null) {
            return this.type;
        }
        block6: for (int i = 0; i <= this.firstProxy; ++i) {
            ExtendedProxyType ptype = ProxyHelper.getProxyType(this.chain[i]);
            switch (ptype) {
                case NOT_A_PROXY: {
                    continue block6;
                }
                case DRAFT_RFC: {
                    if (this.type == null) {
                        this.type = ProxyChainType.DRAFT_RFC;
                        continue block6;
                    }
                    if (this.type == ProxyChainType.DRAFT_RFC) continue block6;
                    this.type = ProxyChainType.MIXED;
                    continue block6;
                }
                case RFC3820: {
                    if (this.type == null) {
                        this.type = ProxyChainType.RFC3820;
                        continue block6;
                    }
                    if (this.type == ProxyChainType.RFC3820) continue block6;
                    this.type = ProxyChainType.MIXED;
                    continue block6;
                }
                case LEGACY: {
                    if (this.type == null) {
                        this.type = ProxyChainType.LEGACY;
                        continue block6;
                    }
                    if (this.type == ProxyChainType.LEGACY) continue block6;
                    this.type = ProxyChainType.MIXED;
                }
            }
        }
        return this.type;
    }

    public int getFirstProxyPosition() {
        return this.firstProxy;
    }

    public boolean isLimited() throws CertificateException, IOException {
        if (this.limited != null) {
            return this.limited;
        }
        for (int i = 0; i <= this.firstProxy; ++i) {
            if (!ProxyHelper.isLimited(this.chain[i])) continue;
            this.limited = true;
            return true;
        }
        this.limited = false;
        return false;
    }

    public ProxyPolicy[] getPolicy() throws IOException {
        if (this.policy != null) {
            return this.policy;
        }
        ArrayList<ProxyPolicy> policies = new ArrayList<ProxyPolicy>();
        for (int i = this.firstProxy; i >= 0; --i) {
            ProxyCertInfoExtension ext;
            ExtendedProxyType type = ProxyHelper.getProxyType(this.chain[i]);
            if (type != ExtendedProxyType.DRAFT_RFC && type != ExtendedProxyType.RFC3820 || (ext = ProxyCertInfoExtension.getInstance(this.chain[i])) == null) continue;
            policies.add(ext.getPolicy());
        }
        this.policy = policies.toArray(new ProxyPolicy[policies.size()]);
        return this.policy;
    }

    public String[] getProxyTracingIssuers() throws IOException {
        String[] ret = new String[this.chain.length];
        for (int i = 0; i < this.chain.length; ++i) {
            ProxyTracingExtension extension = ProxyTracingExtension.getInstance(this.chain[i], true);
            ret[i] = extension == null ? null : extension.getURL();
        }
        return ret;
    }

    public String[] getProxyTracingSubjects() throws IOException {
        String[] ret = new String[this.chain.length];
        for (int i = 0; i < this.chain.length; ++i) {
            ProxyTracingExtension extension = ProxyTracingExtension.getInstance(this.chain[i], false);
            ret[i] = extension == null ? null : extension.getURL();
        }
        return ret;
    }

    public String[] getSAMLExtensions() throws IOException {
        String[] ret = new String[this.chain.length];
        for (int i = 0; i < this.chain.length; ++i) {
            ProxySAMLExtension extension = ProxySAMLExtension.getInstance(this.chain[i]);
            if (extension == null) continue;
            ret[i] = extension.getSAML();
        }
        return ret;
    }

    public AttributeCertificate[][] getAttributeCertificateExtensions() throws IOException {
        AttributeCertificate[][] ret = new AttributeCertificate[this.chain.length][];
        for (int i = 0; i < this.chain.length; ++i) {
            ProxyACExtension extension = ProxyACExtension.getInstance(this.chain[i]);
            if (extension == null) continue;
            ret[i] = extension.getAttributeCertificates();
        }
        return ret;
    }

    public int getRemainingPathLimit() throws IOException {
        int remainingLen = Integer.MAX_VALUE;
        for (int i = this.firstProxy; i >= 0; --i) {
            int lenRestriction = ProxyHelper.getProxyPathLimit(this.chain[i]);
            if (lenRestriction < remainingLen) {
                remainingLen = lenRestriction;
                continue;
            }
            --remainingLen;
        }
        return remainingLen;
    }

    public byte[][][] getProxySourceRestrictions() throws IOException {
        return this.getProxyRestrictions(true);
    }

    public byte[][][] getProxyTargetRestrictions() throws IOException {
        return this.getProxyRestrictions(false);
    }

    public boolean isHostAllowedAsSource(byte[] ipAddress) throws IOException {
        return this.isHostAllowed(ipAddress, this.getProxySourceRestrictions());
    }

    public boolean isHostAllowedAsTarget(byte[] ipAddress) throws IOException {
        return this.isHostAllowed(ipAddress, this.getProxyTargetRestrictions());
    }

    private List<List<byte[]>> union(byte[][] newSpaces, List<byte[]> ipV4Spaces, List<byte[]> ipV6Spaces) {
        ArrayList<List<byte[]>> ret = new ArrayList<List<byte[]>>();
        if (newSpaces == null) {
            ret.add(ipV4Spaces);
            ret.add(ipV6Spaces);
            return ret;
        }
        ArrayList<byte[]> newIPv4 = new ArrayList<byte[]>();
        ArrayList<byte[]> newIPv6 = new ArrayList<byte[]>();
        if (ipV4Spaces != null) {
            newIPv4.addAll(ipV4Spaces);
        }
        if (ipV6Spaces != null) {
            newIPv6.addAll(ipV6Spaces);
        }
        for (int i = 0; i < newSpaces.length; ++i) {
            if (newSpaces[i].length == 8) {
                newIPv4.add(newSpaces[i]);
                continue;
            }
            if (newSpaces[i].length == 32) {
                newIPv6.add(newSpaces[i]);
                continue;
            }
            throw new IllegalArgumentException("IP space definition has to be either 8 bytes or 32 bytes, length was: " + newSpaces.length);
        }
        ret.add(newIPv4);
        ret.add(newIPv6);
        return ret;
    }

    private List<List<byte[]>> intersection(byte[][] newSpaces, List<byte[]> ipV4Spaces, List<byte[]> ipV6Spaces) {
        ArrayList<List<byte[]>> ret = new ArrayList<List<byte[]>>();
        if (newSpaces == null) {
            ret.add(ipV4Spaces);
            ret.add(ipV6Spaces);
            return ret;
        }
        ArrayList<byte[]> newIPv4 = new ArrayList<byte[]>();
        ArrayList newIPv6 = new ArrayList();
        for (int i = 0; i < newSpaces.length; ++i) {
            int len;
            ArrayList<byte[]> newIPs;
            if (newSpaces[i].length == 8) {
                newIPs = newIPv4;
                len = 8;
            } else if (newSpaces[i].length == 32) {
                newIPs = newIPv6;
                len = 32;
            } else {
                throw new IllegalArgumentException("Invalid namespace definition, length should be 8 or 32 bytes. It was: " + newSpaces[i].length + " bytes.");
            }
            if (ipV4Spaces != null && ipV6Spaces != null) {
                byte[] ip = Arrays.copyOfRange(newSpaces[i], 0, len / 2);
                for (byte[] oldSpace : newIPs) {
                    if (!IPAddressHelper.isWithinAddressSpace(ip, oldSpace)) continue;
                    boolean newTighter = true;
                    for (int n = 0; n < len / 2; ++n) {
                        if ((oldSpace[n + len / 2] & 0xFF) >= (newSpaces[i][n + len / 2] & 0xFF)) continue;
                        newTighter = false;
                        break;
                    }
                    if (newTighter) {
                        newIPs.add(newSpaces[i]);
                        continue;
                    }
                    newIPs.add(oldSpace);
                }
                continue;
            }
            newIPs.add(newSpaces[i]);
        }
        ret.add(newIPv4);
        ret.add(newIPv6);
        return ret;
    }

    private byte[][][] getProxyRestrictions(boolean source) throws IOException {
        List<byte[]> allowedIPv4Spaces = null;
        List<byte[]> allowedIPv6Spaces = null;
        List<byte[]> excludedIPv4Spaces = null;
        List<byte[]> excludedIPv6Spaces = null;
        boolean found = false;
        for (int i = this.chain.length - 1; i >= 0; --i) {
            ProxyAddressRestrictionData restrictions = ProxyAddressRestrictionData.getInstance(this.chain[i], source);
            if (restrictions == null) continue;
            found = true;
            byte[][][] spaces = restrictions.getIPSpaces();
            List<List<byte[]>> newSpaces = this.intersection(spaces[0], allowedIPv4Spaces, allowedIPv6Spaces);
            allowedIPv4Spaces = newSpaces.get(0);
            allowedIPv6Spaces = newSpaces.get(1);
            newSpaces = this.union(spaces[1], excludedIPv4Spaces, excludedIPv6Spaces);
            excludedIPv4Spaces = newSpaces.get(0);
            excludedIPv6Spaces = newSpaces.get(1);
        }
        if (!found) {
            return null;
        }
        byte[][][] newSpaces = new byte[][][]{allowedIPv4Spaces != null && allowedIPv6Spaces != null ? ProxyChainInfo.concatArrays((byte[][])allowedIPv4Spaces.toArray((T[])new byte[0][0]), (byte[][])allowedIPv6Spaces.toArray((T[])new byte[0][0])) : (byte[][])new byte[0][], excludedIPv4Spaces != null && excludedIPv6Spaces != null ? ProxyChainInfo.concatArrays((byte[][])excludedIPv4Spaces.toArray((T[])new byte[0][0]), (byte[][])excludedIPv6Spaces.toArray((T[])new byte[0][0])) : (byte[][])new byte[0][]};
        return newSpaces;
    }

    private boolean isHostAllowed(byte[] ipAddress, byte[][][] restrictions) throws IOException {
        int i;
        if (restrictions == null) {
            return true;
        }
        for (i = 0; i < restrictions[1].length; ++i) {
            if (!IPAddressHelper.isWithinAddressSpace(ipAddress, restrictions[1][i])) continue;
            return false;
        }
        for (i = 0; i < restrictions[0].length; ++i) {
            if (!IPAddressHelper.isWithinAddressSpace(ipAddress, restrictions[0][i])) continue;
            return true;
        }
        return false;
    }

    public static byte[][] concatArrays(byte[][] first, byte[][] second) {
        int i;
        int firstLen = first.length;
        int secondLen = second.length;
        byte[][] newByteArrays = new byte[firstLen + secondLen][];
        for (i = 0; i < firstLen; ++i) {
            newByteArrays[i] = first[i];
        }
        for (i = 0; i < secondLen; ++i) {
            newByteArrays[i + firstLen] = second[i];
        }
        return newByteArrays;
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

