/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.utils;

import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.DBEventManagerConstants;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessagingFactory;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.model.dbevent.CrudType;
import org.apache.airavata.model.dbevent.DBEventMessage;
import org.apache.airavata.model.dbevent.DBEventMessageContext;
import org.apache.airavata.model.dbevent.DBEventPublisher;
import org.apache.airavata.model.dbevent.DBEventPublisherContext;
import org.apache.airavata.model.dbevent.DBEventType;
import org.apache.airavata.model.dbevent.EntityType;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProfileServiceUtils.class);
    private static Publisher dbEventPublisher = null;

    public static Publisher getDbEventPublisher() throws AiravataException {
        if (dbEventPublisher == null) {
            dbEventPublisher = MessagingFactory.getDBEventPublisher();
        }
        return dbEventPublisher;
    }

    public static MessageContext getDBEventMessageContext(EntityType entityType, CrudType crudType, TBase entityModel) throws AiravataException {
        try {
            DBEventMessage dbEventMessage = new DBEventMessage();
            DBEventPublisherContext publisherContext = new DBEventPublisherContext();
            publisherContext.setCrudType(crudType);
            publisherContext.setEntityDataModel(ThriftUtils.serializeThriftObject((TBase)entityModel));
            publisherContext.setEntityType(entityType);
            DBEventPublisher dbEventPublisher = new DBEventPublisher();
            dbEventPublisher.setPublisherContext(publisherContext);
            DBEventMessageContext dbMessageContext = DBEventMessageContext.publisher((DBEventPublisher)dbEventPublisher);
            dbEventMessage.setDbEventType(DBEventType.PUBLISHER);
            dbEventMessage.setPublisherService(DBEventManagerConstants.getDbEventServiceName((EntityType)entityType));
            dbEventMessage.setMessageContext(dbMessageContext);
            return new MessageContext((TBase)dbEventMessage, MessageType.DB_EVENT, "", "");
        }
        catch (Exception ex) {
            throw new AiravataException(ex.getMessage(), (Throwable)ex);
        }
    }
}

