/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.spi.MultiResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneMultiResource
implements MultiResource,
Map<String, Property[]> {
    private LuceneResource currentResource;
    private ArrayList<Resource> resources = new ArrayList();
    private String alias;
    private transient LuceneSearchEngineFactory searchEngineFactory;

    public LuceneMultiResource(String alias, LuceneSearchEngineFactory searchEngineFactory) {
        this.alias = alias;
        this.searchEngineFactory = searchEngineFactory;
        this.currentResource = new LuceneResource(alias, searchEngineFactory);
        this.resources.add(this.currentResource);
    }

    @Override
    public int size() {
        return this.resources.size();
    }

    @Override
    public Resource currentResource() {
        return this.currentResource;
    }

    @Override
    public ResourceKey resourceKey() {
        return this.currentResource.resourceKey();
    }

    @Override
    public String getSubIndex() {
        return this.currentResource.getSubIndex();
    }

    @Override
    public void addResource() {
        this.currentResource = new LuceneResource(this.alias, this.searchEngineFactory);
        this.resources.add(this.currentResource);
    }

    @Override
    public Resource resource(int i) {
        return this.resources.get(i);
    }

    @Override
    public void clear() {
        this.resources.clear();
        this.currentResource = null;
    }

    @Override
    public String getAlias() {
        return this.currentResource.getAlias();
    }

    @Override
    public String getUID() {
        return this.currentResource.getUID();
    }

    @Override
    public String getId() {
        return this.currentResource.getId();
    }

    @Override
    public String[] getIds() {
        return this.currentResource.getIds();
    }

    @Override
    public Property getIdProperty() {
        return this.currentResource.getIdProperty();
    }

    @Override
    public Property[] getIdProperties() {
        return this.currentResource.getIdProperties();
    }

    @Override
    public String getValue(String name) {
        return this.currentResource.getValue(name);
    }

    @Override
    public Object getObject(String name) {
        return this.currentResource.getObject(name);
    }

    @Override
    public Object[] getObjects(String name) {
        return this.currentResource.getObjects(name);
    }

    @Override
    public String[] getValues(String name) {
        return this.currentResource.getValues(name);
    }

    @Override
    public Resource addProperty(String name, Object value) throws SearchEngineException {
        this.currentResource.addProperty(name, value);
        return this;
    }

    @Override
    public Resource addProperty(String name, Reader value) throws SearchEngineException {
        this.currentResource.addProperty(name, value);
        return this;
    }

    @Override
    public Resource addProperty(Property property) {
        this.currentResource.addProperty(property);
        return this;
    }

    @Override
    public Resource setProperty(String name, Object value) throws SearchEngineException {
        this.currentResource.setProperty(name, value);
        return this;
    }

    @Override
    public Resource setProperty(String name, Reader value) throws SearchEngineException {
        this.currentResource.setProperty(name, value);
        return this;
    }

    @Override
    public Resource setProperty(Property property) {
        this.currentResource.setProperty(property);
        return this;
    }

    @Override
    public Resource removeProperty(String name) {
        this.currentResource.removeProperty(name);
        return this;
    }

    @Override
    public Resource removeProperties(String name) {
        this.currentResource.removeProperties(name);
        return this;
    }

    @Override
    public Property getProperty(String name) {
        return this.currentResource.getProperty(name);
    }

    @Override
    public Property[] getProperties(String name) {
        return this.currentResource.getProperties(name);
    }

    @Override
    public Property[] getProperties() {
        return this.currentResource.getProperties();
    }

    @Override
    public float getBoost() {
        return this.currentResource.getBoost();
    }

    @Override
    public Resource setBoost(float boost) {
        this.currentResource.setBoost(boost);
        return this;
    }

    @Override
    public void addUID() {
        this.currentResource.addUID();
    }

    @Override
    public void copy(Resource resource) {
        this.clear();
        if (resource instanceof MultiResource) {
            MultiResource multiResource = (MultiResource)resource;
            for (int i = 0; i < multiResource.size(); ++i) {
                this.addResource();
                this.currentResource.copy(multiResource.resource(i));
            }
        } else {
            this.currentResource = (LuceneResource)resource;
            this.resources.add(resource);
        }
    }

    public String toString() {
        if (this.resources.size() == 1) {
            return this.resource(0).toString();
        }
        return StringUtils.collectionToCommaDelimitedString(this.resources);
    }

    @Override
    public boolean isEmpty() {
        return this.currentResource.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.currentResource.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.currentResource.containsValue(value);
    }

    @Override
    public Collection<Property[]> values() {
        return this.currentResource.values();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Property[]> t) {
        this.currentResource.putAll(t);
    }

    @Override
    public Set<Map.Entry<String, Property[]>> entrySet() {
        return this.currentResource.entrySet();
    }

    @Override
    public Set<String> keySet() {
        return this.currentResource.keySet();
    }

    @Override
    public Property[] get(Object key) {
        return this.currentResource.get(key);
    }

    @Override
    public Property[] remove(Object key) {
        return this.currentResource.remove(key);
    }

    @Override
    public Property[] put(String key, Property[] value) {
        return this.currentResource.put(key, value);
    }
}

