/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.compass.needle.terracotta.TerracottaFile;

public class TerracottaIndexInput
extends IndexInput
implements Cloneable {
    final int bufferSize;
    private TerracottaFile file;
    private long length;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;

    TerracottaIndexInput(TerracottaFile f, int bufferSize) throws IOException {
        this.bufferSize = bufferSize;
        this.file = f;
        this.length = this.file.length;
        if (this.length / (long)this.bufferSize >= Integer.MAX_VALUE) {
            throw new IOException("Too large RAMFile! " + this.length);
        }
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
    }

    public void close() {
    }

    public long length() {
        return this.length;
    }

    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer();
        }
        return this.currentBuffer[this.bufferPosition++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition >= this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            int bytesToCopy = len < (remainInBuffer = this.bufferLength - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(this.currentBuffer, this.bufferPosition, b, offset, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    private void switchCurrentBuffer() throws IOException {
        if (this.currentBufferIndex >= this.file.getNumBuffers()) {
            throw new IOException("Read past EOF");
        }
        this.currentBuffer = this.file.getBuffer(this.currentBufferIndex);
        this.bufferPosition = 0;
        this.bufferStart = (long)this.bufferSize * (long)this.currentBufferIndex;
        long buflen = this.length - this.bufferStart;
        this.bufferLength = buflen > (long)this.bufferSize ? this.bufferSize : (int)buflen;
    }

    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    public void seek(long pos) throws IOException {
        if (this.currentBuffer == null || pos < this.bufferStart || pos >= this.bufferStart + (long)this.bufferSize) {
            this.currentBufferIndex = (int)(pos / (long)this.bufferSize);
            this.switchCurrentBuffer();
        }
        this.bufferPosition = (int)(pos % (long)this.bufferSize);
    }
}

