/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.semaphore;

import com.hazelcast.concurrent.semaphore.AcquireBackupOperation;
import com.hazelcast.concurrent.semaphore.Permit;
import com.hazelcast.concurrent.semaphore.SemaphoreBackupAwareOperation;
import com.hazelcast.concurrent.semaphore.SemaphoreWaitNotifyKey;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;
import java.io.IOException;

public class AcquireOperation
extends SemaphoreBackupAwareOperation
implements WaitSupport {
    long timeout;

    public AcquireOperation() {
    }

    public AcquireOperation(String name, int permitCount, long timeout) {
        super(name, permitCount);
        this.timeout = timeout;
    }

    @Override
    public void run() throws Exception {
        Permit permit = this.getPermit();
        this.response = permit.acquire(this.permitCount, this.getCallerUuid());
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.timeout);
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.timeout = in.readLong();
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new SemaphoreWaitNotifyKey((Object)this.name, "acquire");
    }

    @Override
    public boolean shouldWait() {
        Permit permit = this.getPermit();
        return this.timeout != 0L && !permit.isAvailable(this.permitCount);
    }

    @Override
    public long getWaitTimeoutMillis() {
        return this.timeout;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(false);
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new AcquireBackupOperation(this.name, this.permitCount, this.getCallerUuid());
    }
}

