/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.xml;

import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.azureblob.domain.BlobBlockProperties;
import org.jclouds.azureblob.domain.ListBlobBlocksResponse;
import org.jclouds.azureblob.domain.internal.BlobBlockPropertiesImpl;
import org.jclouds.azureblob.domain.internal.ListBlobBlocksResponseImpl;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BlobBlocksResultsHandler
extends ParseSax.HandlerWithResult<ListBlobBlocksResponse> {
    private StringBuilder currentText = new StringBuilder();
    private boolean inCommitted = false;
    private boolean inBlock = false;
    private boolean inName = false;
    private boolean inSize = false;
    private String blockName;
    private long size;
    private List<BlobBlockProperties> blocks = Lists.newArrayList();

    public ListBlobBlocksResponse getResult() {
        return new ListBlobBlocksResponseImpl(this.blocks);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("CommittedBlocks".equals(qName)) {
            this.inCommitted = true;
        } else if ("UncommittedBlocks".equals(qName)) {
            this.inCommitted = false;
        } else if ("Block".equals(qName)) {
            this.inBlock = true;
        } else if ("Name".equals(qName)) {
            this.inName = true;
        } else if ("Size".equals(qName)) {
            this.inSize = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if ("CommittedBlocks".equals(qName)) {
            this.inCommitted = false;
        } else if ("UncommittedBlocks".equals(qName)) {
            this.inCommitted = false;
        } else if ("Block".equals(qName)) {
            BlobBlockPropertiesImpl block = new BlobBlockPropertiesImpl(this.blockName, this.size, this.inCommitted);
            this.blocks.add(block);
            this.inBlock = false;
        } else if ("Name".equals(qName)) {
            this.blockName = this.currentText.toString().trim();
            this.inName = false;
        } else if ("Size".equals(qName)) {
            this.size = Long.parseLong(this.currentText.toString().trim());
            this.inSize = false;
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

