/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.entity.nosql.mongodb.AbstractMongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBClientImpl;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBShardedDeployment;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=MongoDBClientImpl.class)
public interface MongoDBClient
extends AbstractMongoDBServer {
    public static final MethodEffector<Void> RUN_SCRIPT = new MethodEffector(MongoDBClient.class, "runScript");
    @SetFromFlag(value="startupJsScripts")
    public static final ConfigKey<List<String>> STARTUP_JS_SCRIPTS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"mongodb.client.startupJsScripts", (String)"List of scripts defined in mongodb.client.scripts to be run on startup");
    @SetFromFlag(value="scripts")
    public static final ConfigKey<Map<String, String>> JS_SCRIPTS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"mongodb.client.scripts", (String)"List of javascript scripts to be copied to the server. These scripts can be run using the runScript effector");
    @SetFromFlag(value="shardedDeployment")
    public static final ConfigKey<MongoDBShardedDeployment> SHARDED_DEPLOYMENT = ConfigKeys.newConfigKey(MongoDBShardedDeployment.class, (String)"mongodb.client.shardeddeployment", (String)"Sharded deployment that the client will use to run scripts. If both SERVER and SHARDED_DEPLOYMENT are specified, SERVER will be used");
    @SetFromFlag(value="server")
    public static final ConfigKey<AbstractMongoDBServer> SERVER = ConfigKeys.newConfigKey(AbstractMongoDBServer.class, (String)"mongodb.client.server", (String)"MongoDBServer that the client will use to run scripts. If both SERVER and SHARDED_DEPLOYMENT are specified, SERVER will be used");

    @Effector(description="Runs one of the scripts defined in mongodb.client.scripts")
    public void runScript(@EffectorParam(name="preStart", description="use this to create parameters that can be used by the script, e.g.:<p><code>var loopCount = 10</code>") String var1, @EffectorParam(name="scriptName", description="Name of the script as defined in mongodb.client.scripts") String var2);
}

