/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.tasks.kubectl;

import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.effector.AddSensorInitializer;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.feed.PollConfig;
import org.apache.brooklyn.core.sensor.AbstractAddTriggerableSensor;
import org.apache.brooklyn.core.sensor.ssh.SshCommandSensor;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.tasks.kubectl.ContainerCommons;
import org.apache.brooklyn.tasks.kubectl.ContainerTaskFactory;
import org.apache.brooklyn.tasks.kubectl.ContainerTaskResult;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerSensor<T>
extends AbstractAddTriggerableSensor<T>
implements ContainerCommons {
    public static final ConfigKey<String> FORMAT = SshCommandSensor.FORMAT;
    public static final ConfigKey<Boolean> LAST_YAML_DOCUMENT = SshCommandSensor.LAST_YAML_DOCUMENT;
    private static final Logger LOG = LoggerFactory.getLogger(ContainerSensor.class);

    public ContainerSensor() {
    }

    public ContainerSensor(ConfigBag parameters) {
        super(parameters);
    }

    public void apply(EntityLocal entity) {
        AttributeSensor sensor = this.addSensor(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding container sensor {} to {}", this.initParam(SENSOR_NAME), (Object)entity);
        }
        ConfigBag configBag = ConfigBag.newInstanceCopying((ConfigBag)this.initParams());
        FunctionPollConfig poll = new FunctionPollConfig(sensor).callable((Callable)new ContainerSensorCallable((Entity)entity, configBag, (Sensor<?>)sensor));
        this.standardPollConfig((Entity)entity, configBag, (PollConfig)poll);
        FunctionFeed.builder().name("Container Sensor Feed: " + (String)this.initParam(SENSOR_NAME)).entity((Entity)entity).onlyIfServiceUp(((Boolean)Maybe.ofDisallowingNull((Object)EntityInitializers.resolve((ConfigBag)this.initParams(), (ConfigKey)ONLY_IF_SERVICE_UP)).or((Object)false)).booleanValue()).poll(poll).build(true);
    }

    public static class ContainerSensorCallable
    implements Callable<Object> {
        private final Entity entity;
        private final ConfigBag configBag;
        private final Sensor<?> sensor;

        public ContainerSensorCallable(Entity entity, ConfigBag configBag, Sensor<?> sensor) {
            this.entity = entity;
            this.configBag = configBag;
            this.sensor = sensor;
        }

        @Override
        public Object call() throws Exception {
            Task containerTask = ((ContainerTaskFactory.ConcreteContainerTaskFactory)((ContainerTaskFactory.ConcreteContainerTaskFactory)((ContainerTaskFactory.ConcreteContainerTaskFactory)ContainerTaskFactory.newInstance().summary("Running " + (String)EntityInitializers.resolve((ConfigBag)this.configBag, (ConfigKey)AddSensorInitializer.SENSOR_NAME))).jobIdentifier(this.entity.getApplication() + "-" + this.entity.getId() + "-" + "SENSOR")).configure(this.configBag.getAllConfig())).newTask();
            DynamicTasks.queueIfPossible(containerTask).orSubmitAsync(this.entity);
            String mainStdout = ((ContainerTaskResult)containerTask.getUnchecked((Duration)this.configBag.get(ContainerCommons.TIMEOUT))).getMainStdout();
            return new SshCommandSensor.CoerceOutputFunction(this.sensor.getTypeToken(), (String)this.configBag.get(FORMAT), (Boolean)this.configBag.get(LAST_YAML_DOCUMENT)).apply(mainStdout);
        }

        public String toString() {
            return "container-sensor[" + (String)this.configBag.get(ContainerCommons.CONTAINER_IMAGE) + "]";
        }
    }
}

