/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class TestHttpRequestHandler
implements HttpRequestHandler {
    private HttpEntity entity;
    private int responseCode = 200;
    private Collection<Header> headers = new ArrayList<Header>();

    public TestHttpRequestHandler response(String response) {
        try {
            this.entity = new StringEntity(response);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.propagate(e);
        }
        return this;
    }

    public TestHttpRequestHandler response(byte[] response) {
        this.entity = new ByteArrayEntity(response);
        return this;
    }

    public TestHttpRequestHandler code(int responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public TestHttpRequestHandler header(String name, String value) {
        this.headers.add((Header)new BasicHeader(name, value));
        return this;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        for (Header h : this.headers) {
            response.setHeader(h);
        }
        response.setStatusCode(this.responseCode);
        response.setEntity(this.entity);
    }
}

