/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.guava;

import com.google.common.base.Function;
import com.google.common.cache.AbstractLoadingCache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

public class KeyTransformingLoadingCache<A, B, V>
extends AbstractLoadingCache<A, V> {
    private final LoadingCache<B, V> delegate;
    private final Function<A, B> keyTransformer;

    public KeyTransformingLoadingCache(LoadingCache<B, V> delegate, Function<A, B> keyTransformer) {
        this.delegate = delegate;
        this.keyTransformer = keyTransformer;
    }

    public static <A, B, V> KeyTransformingLoadingCache<A, B, V> from(LoadingCache<B, V> delegate, Function<A, B> keyTransformer) {
        return new KeyTransformingLoadingCache<A, B, V>(delegate, keyTransformer);
    }

    protected Function<A, B> keyTransformer() {
        return this.keyTransformer;
    }

    protected LoadingCache<B, V> delegate() {
        return this.delegate;
    }

    public V getIfPresent(Object key) {
        try {
            Object cast = key;
            return (V)this.delegate().getIfPresent(this.keyTransformer().apply(cast));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public V get(A key, Callable<? extends V> valueLoader) throws ExecutionException {
        return (V)this.delegate().get(this.keyTransformer().apply(key), valueLoader);
    }

    public ImmutableMap<A, V> getAllPresent(Iterable<?> keys) {
        throw new UnsupportedOperationException("getAllPresent in " + ((Object)((Object)this)).getClass().getName() + " undefined");
    }

    public void put(A key, V value) {
        this.delegate().put(this.keyTransformer().apply(key), value);
    }

    public void invalidate(Object key) {
        try {
            Object cast = key;
            this.delegate().invalidate(this.keyTransformer().apply(cast));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void invalidateAll() {
        this.delegate().invalidateAll();
    }

    public long size() {
        return this.delegate().size();
    }

    public CacheStats stats() {
        return this.delegate().stats();
    }

    public V get(A key) throws ExecutionException {
        return (V)this.delegate().get(this.keyTransformer().apply(key));
    }

    public void refresh(A key) {
        this.delegate().refresh(this.keyTransformer().apply(key));
    }

    public ConcurrentMap<A, V> asMap() {
        throw new UnsupportedOperationException("asMap in " + ((Object)((Object)this)).getClass().getName() + " undefined");
    }

    public void cleanUp() {
        this.delegate().cleanUp();
    }

    public static class KeyTransformingSameTypeLoadingCache<A, V>
    extends KeyTransformingLoadingCache<A, A, V> {
        public KeyTransformingSameTypeLoadingCache(LoadingCache<A, V> delegate, Function<A, A> keyTransformer) {
            super(delegate, keyTransformer);
        }

        public static <A, V> KeyTransformingSameTypeLoadingCache<A, V> with(LoadingCache<A, V> delegate, Function<A, A> keyTransformer) {
            return new KeyTransformingSameTypeLoadingCache<A, V>(delegate, keyTransformer);
        }
    }
}

