/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.guava;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.guava.AnyExceptionSupplier;
import org.apache.brooklyn.util.guava.IllegalStateExceptionSupplier;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.javalang.MemoryUsageTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Maybe<T>
implements Serializable,
Supplier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Maybe.class);
    private static final long serialVersionUID = -6372099069863179019L;

    public static <T> Maybe<T> absent() {
        return new Absent();
    }

    public static <T> Maybe<T> absent(String message) {
        return Maybe.absent(new IllegalStateException(message));
    }

    public static <T> Maybe<T> absentWithTrace(String message) {
        return Maybe.absent(new IllegalStateException(message));
    }

    public static <T> Maybe<T> absentNoTrace(String message) {
        return Maybe.absent(new IllegalStateExceptionSupplier(message));
    }

    public static <T> Maybe<T> absent(Throwable cause) {
        return Maybe.absent(new IllegalStateExceptionSupplier(cause));
    }

    public static <T> Maybe<T> absent(String message, Throwable cause) {
        return Maybe.absent(new IllegalStateExceptionSupplier(message, cause));
    }

    public static <T> Maybe<T> absent(Supplier<? extends RuntimeException> exceptionSupplier) {
        return new Absent((Supplier<? extends RuntimeException>)((Supplier)Preconditions.checkNotNull(exceptionSupplier)));
    }

    public static <T> Maybe<T> absentNull() {
        return Maybe.absentNull("disallowed null value");
    }

    public static <T> Maybe<T> absentNull(String message) {
        return new AbsentNull(message);
    }

    public static <T> Maybe<T> ofAllowingNull(@Nullable T value) {
        return new Present<T>(value);
    }

    public static <T> Maybe<T> ofDisallowingNull(@Nullable T value) {
        if (value == null) {
            return Maybe.absentNull();
        }
        return new Present<T>(value);
    }

    public static <T> Maybe<T> of(@Nullable T value) {
        return Maybe.ofAllowingNull(value);
    }

    public static <T> Maybe<T> cast(Maybe<? extends T> value) {
        return value;
    }

    public static <T> Maybe<T> castAbsent(Maybe<?> absent) {
        if (absent != null && absent.isPresent() && !absent.isNull()) {
            throw new IllegalArgumentException("Expected an absent, but instead got: " + absent);
        }
        return absent;
    }

    public com.google.common.base.Optional<T> toOptional() {
        return this.toGuavaOptional();
    }

    public com.google.common.base.Optional<T> toGuavaOptional() {
        if (this.isPresent()) {
            return com.google.common.base.Optional.of(this.get());
        }
        return com.google.common.base.Optional.absent();
    }

    public Optional<T> toJavaOptional() {
        if (this.isPresent()) {
            return Optional.of(this.get());
        }
        return Optional.empty();
    }

    public static <T> Maybe<T> fromNullable(@Nullable T value) {
        return Maybe.ofDisallowingNull(value);
    }

    public static <T> Maybe<T> fromOptional(com.google.common.base.Optional<T> value) {
        return new MaybeGuavaOptional<T>(value);
    }

    public static <T> Maybe<T> fromOptional(Optional<T> value) {
        return new MaybeJavaOptional<T>(value);
    }

    public static <T> Maybe<T> soft(@Nonnull T value) {
        return Maybe.softThen(value, null);
    }

    public static <T> Maybe<T> softThen(T value, Maybe<T> ifEmpty) {
        if (value == null) {
            return Maybe.of(null);
        }
        return new SoftlyPresent<T>(value).usingAfterExpiry(ifEmpty);
    }

    public static <T> Maybe<T> of(com.google.common.base.Optional<T> value) {
        return Maybe.fromOptional(value);
    }

    private static <T> Maybe<T> ofOldKeptForDeserializationOfAnonymousInnerClass(final com.google.common.base.Optional<T> value) {
        if (value.isPresent()) {
            return new AbstractPresent<T>(){
                private static final long serialVersionUID = -5735268814211401356L;

                @Override
                public T get() {
                    return value.get();
                }
            };
        }
        return Maybe.absent();
    }

    public static <T> Maybe<T> of(Optional<T> value) {
        return Maybe.fromOptional(value);
    }

    private static <T> Maybe<T> ofOldKeptForDeserializationOfAnonymousInnerClass(final Supplier<T> value) {
        return new AbstractPresent<T>(){
            private static final long serialVersionUID = -5735268814211401356L;

            @Override
            public T get() {
                return value.get();
            }
        };
    }

    public static <T> Maybe<T> of(Supplier<T> value) {
        return new MaybeSupplier<T>(value);
    }

    public static <T> Maybe<T> next(Iterator<T> iterator) {
        return iterator.hasNext() ? Maybe.of(iterator.next()) : Maybe.absent();
    }

    public abstract boolean isPresent();

    public abstract T get();

    public boolean isAbsent() {
        return !this.isPresent();
    }

    public boolean isAbsentOrNull() {
        return this.isAbsent() || this.isNull();
    }

    public boolean isPresentAndNonNull() {
        return this.isPresent() && !this.isNull();
    }

    public abstract boolean isNull();

    public T or(T nextValue) {
        if (this.isPresent()) {
            return this.get();
        }
        return nextValue;
    }

    public Maybe<T> or(Maybe<T> nextValue) {
        if (this.isPresent()) {
            return this;
        }
        return nextValue;
    }

    public T or(Supplier<T> nextValue) {
        if (this.isPresent()) {
            return this.get();
        }
        return (T)nextValue.get();
    }

    public Maybe<T> orMaybe(Supplier<Maybe<T>> nextValue) {
        if (this.isPresent()) {
            return this;
        }
        return (Maybe)nextValue.get();
    }

    public T orNull() {
        if (this.isPresent()) {
            return this.get();
        }
        return null;
    }

    public T orThrowUnwrapped() {
        return this.get();
    }

    public Maybe<T> orThrowing(String message) {
        return this.or(Maybe.absent(message));
    }

    public Maybe<T> orThrowing(Throwable t) {
        return this.or(Maybe.absent(t));
    }

    public Maybe<T> orThrowing(Supplier<RuntimeException> t) {
        return this.or(Maybe.absent(t));
    }

    public T orThrow(String message) {
        return this.orThrowing(message).get();
    }

    public T orThrow(Throwable t) {
        return this.orThrowing(t).get();
    }

    public T orThrow(Supplier<RuntimeException> t) {
        return this.orThrowing(t).get();
    }

    public Set<T> asSet() {
        if (this.isPresent()) {
            return ImmutableSet.of(this.get());
        }
        return Collections.emptySet();
    }

    public <V> Maybe<V> transform(Function<? super T, V> f) {
        return this.map(f);
    }

    public <V> Maybe<V> map(java.util.function.Function<? super T, V> f) {
        return new MaybeTransforming<T, V>(this, f);
    }

    public <V> Maybe<V> map(Function<? super T, V> f) {
        return new MaybeTransforming<T, V>(this, f);
    }

    public <V> Maybe<V> mapMaybe(Function<? super T, Maybe<V>> f) {
        return new MaybeTransformingMaybe<T, V>(this, f);
    }

    private <V> Maybe<V> mapKeptForDeserializingOld(final Function<? super T, V> f) {
        if (this.isPresent()) {
            return new AbstractPresent<V>(){
                private static final long serialVersionUID = 325089324325L;

                @Override
                public V get() {
                    return f.apply(Maybe.this.get());
                }
            };
        }
        return this;
    }

    public <V> Maybe<V> transformNow(Function<? super T, V> f) {
        if (this.isPresent()) {
            return Maybe.of(f.apply(this.get()));
        }
        return this;
    }

    public Maybe<T> apply(Consumer<? super T> f) {
        if (this.isPresent()) {
            f.accept(this.get());
        }
        return this;
    }

    @Beta
    public static <T> Iterable<T> presentInstances(final Iterable<? extends Maybe<? extends T>> maybes) {
        Preconditions.checkNotNull(maybes);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    private final Iterator<? extends Maybe<? extends T>> iterator;
                    {
                        this.iterator = (Iterator)Preconditions.checkNotNull(maybes.iterator());
                    }

                    protected T computeNext() {
                        while (this.iterator.hasNext()) {
                            Maybe maybe = this.iterator.next();
                            if (!maybe.isPresent()) continue;
                            return maybe.get();
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }

    public String toString() {
        return JavaClassNames.simpleClassName(this) + "[" + (this.isPresent() ? "value=" + this.get() : "") + "]";
    }

    public int hashCode() {
        if (!this.isPresent()) {
            return Objects.hashCode((Object[])new Object[]{31, this.isPresent()});
        }
        return Objects.hashCode((Object[])new Object[]{31, this.get()});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Maybe)) {
            return false;
        }
        Maybe other = (Maybe)obj;
        if (!this.isPresent()) {
            return !other.isPresent();
        }
        if (!other.isPresent()) {
            return false;
        }
        return Objects.equal(this.get(), other.get());
    }

    public static RuntimeException getException(Maybe<?> t) {
        if (t instanceof Absent) {
            return ((Absent)t).getException();
        }
        if (t.isPresent()) {
            return null;
        }
        if (t instanceof MaybeTransforming) {
            return Maybe.getException(((MaybeTransforming)t).input);
        }
        try {
            t.get();
        }
        catch (RuntimeException e) {
            return e;
        }
        return new RuntimeException("Unsupported exception access on maybe type " + t.getClass() + ", not present, but not in error: " + t);
    }

    public static class SoftlyPresent<T>
    extends Maybe<T> {
        private static final MemoryUsageTracker.SoftUsageTracker TRACKER = new MemoryUsageTracker.SoftUsageTracker();
        private static final long serialVersionUID = 436799990500336015L;
        private final SoftReference<T> value;
        private Maybe<T> defaultValue;

        protected SoftlyPresent(@Nonnull T value) {
            this.value = new SoftReference<T>(value);
            TRACKER.track(this, this.value);
        }

        @Override
        public T get() {
            T result = this.value.get();
            if (result != null) {
                return result;
            }
            if (this.defaultValue == null) {
                throw new IllegalStateException("Softly present item has been GC'd");
            }
            return this.defaultValue.get();
        }

        @Override
        public T orNull() {
            T result = this.value.get();
            if (result != null) {
                return result;
            }
            if (this.defaultValue == null) {
                return null;
            }
            return this.defaultValue.orNull();
        }

        @Override
        public boolean isPresent() {
            return this.value.get() != null || this.defaultValue != null && this.defaultValue.isPresent();
        }

        @Override
        public boolean isNull() {
            return false;
        }

        public Maybe<T> solidify() {
            return Maybe.fromNullable(this.value.get());
        }

        SoftlyPresent<T> usingAfterExpiry(Maybe<T> defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public static MemoryUsageTracker.SoftUsageTracker getUsageTracker() {
            return TRACKER;
        }
    }

    public static class Present<T>
    extends AbstractPresent<T> {
        private static final long serialVersionUID = 436799990500336015L;
        private final T value;

        protected Present(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }
    }

    public static abstract class AbstractPresent<T>
    extends Maybe<T> {
        private static final long serialVersionUID = -2266743425340870492L;

        protected AbstractPresent() {
        }

        @Override
        public boolean isNull() {
            return this.get() == null;
        }

        @Override
        public boolean isPresent() {
            return true;
        }
    }

    public static class AbsentNull<T>
    extends Absent<T> {
        private static final long serialVersionUID = 2422627709567857268L;

        public AbsentNull(String message) {
            super(new IllegalStateExceptionSupplier(message));
        }

        @Override
        public boolean isNull() {
            return true;
        }
    }

    public static class Absent<T>
    extends Maybe<T> {
        private static final long serialVersionUID = -757170462010887057L;
        private final Supplier<? extends RuntimeException> exception;

        public Absent() {
            this(IllegalStateExceptionSupplier.EMPTY_EXCEPTION);
        }

        public Absent(Supplier<? extends RuntimeException> exception) {
            this.exception = exception;
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public T get() {
            throw this.getException();
        }

        @Override
        public T orThrowUnwrapped() {
            throw this.getException();
        }

        public RuntimeException getException() {
            return (RuntimeException)this.exception.get();
        }

        public Supplier<? extends RuntimeException> getExceptionSupplier() {
            return this.exception;
        }

        public static <T> Maybe<T> changeExceptionSupplier(Maybe<T> original, final Class<? extends RuntimeException> type) {
            return Absent.changeExceptionSupplier(original, new Function<AnyExceptionSupplier<?>, Supplier<? extends RuntimeException>>(){

                public Supplier<? extends RuntimeException> apply(AnyExceptionSupplier<?> input) {
                    if (type.isInstance(input)) {
                        return input;
                    }
                    return new AnyExceptionSupplier(type, input.getMessageSupplier(), input.getCause());
                }
            });
        }

        public static <T> Maybe<T> changeExceptionSupplier(Maybe<T> original, Function<AnyExceptionSupplier<?>, Supplier<? extends RuntimeException>> transform) {
            if (original == null || original.isPresent()) {
                return original;
            }
            while (original instanceof MaybeTransforming) {
                original = ((MaybeTransforming)original).input;
            }
            if (!(original instanceof Absent)) {
                LOG.debug("Cannot replace exception supplier for " + original.getClass() + " " + original + "; ignoring");
                LOG.trace("Cannot replace exception supplier for " + original.getClass() + " " + original + "; trace supplied", new Throwable("trace for irreplaceable exception supplier"));
                return original;
            }
            Supplier<RuntimeException> supplier = ((Absent)original).getExceptionSupplier();
            if (!(supplier instanceof AnyExceptionSupplier)) {
                return original;
            }
            return Maybe.absent((Supplier<? extends RuntimeException>)((Supplier)transform.apply((Object)((AnyExceptionSupplier)supplier))));
        }
    }

    public static class MaybeTransformingMaybe<T, V>
    extends Maybe<V> {
        private static final long serialVersionUID = 325089324325L;
        private final Maybe<T> input;
        private final Function<? super T, Maybe<V>> f;
        private boolean gotten = false;
        private Maybe<V> gottenObject;

        public MaybeTransformingMaybe(Maybe<T> input, Function<? super T, Maybe<V>> f) {
            this.input = input;
            this.f = f;
        }

        @Override
        public boolean isPresent() {
            if (!this.input.isPresent()) {
                return false;
            }
            this.evaluate();
            return this.gottenObject.isPresent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() {
            if (!this.gotten) {
                MaybeTransformingMaybe maybeTransformingMaybe = this;
                synchronized (maybeTransformingMaybe) {
                    if (!this.gotten) {
                        this.gotten = true;
                        if (!this.input.isPresent()) {
                            this.gottenObject = Maybe.castAbsent(this.input);
                            return;
                        }
                        this.gottenObject = (Maybe)this.f.apply(this.input.get());
                        if (this.gottenObject == null) {
                            this.gottenObject = Maybe.absent("transformation yielded null rather than a maybe");
                        }
                    }
                }
            }
        }

        @Override
        public V get() {
            this.evaluate();
            return this.gottenObject.get();
        }

        @Override
        public boolean isNull() {
            return this.isPresent() ? this.get() == null : this.input.isNull();
        }
    }

    public static class MaybeTransforming<T, V>
    extends Maybe<V> {
        private static final long serialVersionUID = 325089324325L;
        private final Maybe<T> input;
        private final java.util.function.Function<? super T, V> f;

        public MaybeTransforming(Maybe<T> input, java.util.function.Function<? super T, V> f) {
            this.input = input;
            this.f = f;
        }

        @Override
        public boolean isPresent() {
            return this.input.isPresent();
        }

        @Override
        public V get() {
            return this.f.apply(this.input.get());
        }

        @Override
        public boolean isNull() {
            return this.isPresent() ? this.get() == null : this.input.isNull();
        }
    }

    public static class MaybeSupplier<T>
    extends AbstractPresent<T> {
        private static final long serialVersionUID = -823731500051341455L;
        private final Supplier<T> supplier;

        public MaybeSupplier(Supplier<T> value) {
            this.supplier = value;
        }

        @Override
        public T get() {
            return (T)this.supplier.get();
        }

        public Supplier<T> getSupplier() {
            return this.supplier;
        }
    }

    public static class MaybeJavaOptional<T>
    extends Maybe<T> {
        private static final long serialVersionUID = -823731500051341455L;
        private final Optional<T> value;

        public MaybeJavaOptional(Optional<T> value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value.get();
        }

        @Override
        public boolean isNull() {
            return false;
        }

        public Optional<T> getOptional() {
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return this.value.isPresent();
        }
    }

    public static class MaybeGuavaOptional<T>
    extends Maybe<T> {
        private static final long serialVersionUID = -823731500051341455L;
        private final com.google.common.base.Optional<T> value;

        public MaybeGuavaOptional(com.google.common.base.Optional<T> value) {
            this.value = value;
        }

        @Override
        public T get() {
            return (T)this.value.get();
        }

        @Override
        public boolean isNull() {
            return false;
        }

        public com.google.common.base.Optional<T> getOptional() {
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return this.value.isPresent();
        }
    }
}

