/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.activemq;

import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQBroker;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQDriver;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQQueue;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQTopic;
import org.apache.brooklyn.entity.messaging.jms.JMSBrokerImpl;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQBrokerImpl
extends JMSBrokerImpl<ActiveMQQueue, ActiveMQTopic>
implements ActiveMQBroker {
    private static final Logger log = LoggerFactory.getLogger(ActiveMQBrokerImpl.class);
    private volatile JmxFeed jmxFeed;

    public void init() {
        super.init();
        Entities.getRequiredUrlConfig((Entity)this, (ConfigKey.HasConfigKey)TEMPLATE_CONFIGURATION_URL);
    }

    @Override
    public void setBrokerUrl() {
        this.sensors().set(BROKER_URL, (Object)String.format("tcp://%s:%d", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)OPEN_WIRE_PORT)));
    }

    public Integer getJmxPort() {
        return !this.isJmxEnabled() ? Integer.valueOf(-1) : (Integer)this.getAttribute((AttributeSensor)UsesJmx.JMX_PORT);
    }

    public String getBrokerName() {
        return (String)this.getAttribute((AttributeSensor)BROKER_NAME);
    }

    public Integer getOpenWirePort() {
        return (Integer)this.getAttribute((AttributeSensor)OPEN_WIRE_PORT);
    }

    public boolean isJmxEnabled() {
        return Boolean.TRUE.equals(this.getConfig(USE_JMX));
    }

    @Override
    public ActiveMQQueue createQueue(Map properties) {
        ActiveMQQueue result = (ActiveMQQueue)this.addChild((EntitySpec)EntitySpec.create(ActiveMQQueue.class).configure(properties));
        result.create();
        return result;
    }

    @Override
    public ActiveMQTopic createTopic(Map properties) {
        ActiveMQTopic result = (ActiveMQTopic)this.addChild((EntitySpec)EntitySpec.create(ActiveMQTopic.class).configure(properties));
        result.create();
        return result;
    }

    @Override
    protected void connectSensors() {
        this.sensors().set(BROKER_URL, (Object)String.format("tcp://%s:%d", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)OPEN_WIRE_PORT)));
        String brokerMbeanName = "org.apache.activemq:type=Broker,brokerName=" + this.getBrokerName();
        this.jmxFeed = JmxFeed.builder().entity((Entity)this).period(500L, TimeUnit.MILLISECONDS).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(SERVICE_UP).objectName(brokerMbeanName).attributeName("BrokerName").onSuccess(Functions.forPredicate((Predicate)Predicates.notNull()))).onFailureOrException(Functions.constant((Object)false))).suppressDuplicates(true)).build();
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("openWirePort", this.getAttribute((AttributeSensor)OPEN_WIRE_PORT));
    }

    public Class getDriverInterface() {
        return ActiveMQDriver.class;
    }
}

