/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.catalog;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.catalog.ServiceEndpoint;
import org.jclouds.openstack.keystone.v3.domain.Catalog;
import org.jclouds.openstack.keystone.v3.domain.Endpoint;
import org.jclouds.openstack.keystone.v3.domain.Token;

@Singleton
public class V3ServiceCatalog
implements Supplier<List<ServiceEndpoint>> {
    @Resource
    private Logger logger = Logger.NULL;
    private final Supplier<AuthInfo> authInfo;

    @Inject
    V3ServiceCatalog(Supplier<AuthInfo> authInfo) {
        this.authInfo = authInfo;
    }

    public List<ServiceEndpoint> get() {
        Token token = (Token)this.authInfo.get();
        ImmutableList.Builder serviceEndpoints = ImmutableList.builder();
        for (Catalog catalog : token.catalog()) {
            for (Endpoint endpoint : catalog.endpoints()) {
                serviceEndpoints.add((Object)ServiceEndpoint.builder().id(endpoint.id()).iface(endpoint.iface()).regionId(endpoint.regionId()).type(catalog.type()).url(endpoint.url()).build());
            }
        }
        return serviceEndpoints.build();
    }
}

