/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.NovaComputeService;
import org.jclouds.openstack.nova.v2_0.compute.NovaComputeServiceAdapter;
import org.jclouds.openstack.nova.v2_0.compute.extensions.NeutronSecurityGroupExtension;
import org.jclouds.openstack.nova.v2_0.compute.extensions.NovaImageExtension;
import org.jclouds.openstack.nova.v2_0.compute.extensions.NovaSecurityGroupExtension;
import org.jclouds.openstack.nova.v2_0.compute.functions.CleanupResources;
import org.jclouds.openstack.nova.v2_0.compute.functions.CreateSecurityGroupIfNeeded;
import org.jclouds.openstack.nova.v2_0.compute.functions.FlavorInRegionToHardware;
import org.jclouds.openstack.nova.v2_0.compute.functions.ImageInRegionToImage;
import org.jclouds.openstack.nova.v2_0.compute.functions.ImageToOperatingSystem;
import org.jclouds.openstack.nova.v2_0.compute.functions.NeutronSecurityGroupToSecurityGroup;
import org.jclouds.openstack.nova.v2_0.compute.functions.NovaSecurityGroupInRegionToSecurityGroup;
import org.jclouds.openstack.nova.v2_0.compute.functions.NovaSecurityGroupToSecurityGroup;
import org.jclouds.openstack.nova.v2_0.compute.functions.OrphanedGroupsByRegionId;
import org.jclouds.openstack.nova.v2_0.compute.functions.ServerInRegionToNodeMetadata;
import org.jclouds.openstack.nova.v2_0.compute.loaders.FindSecurityGroupOrCreate;
import org.jclouds.openstack.nova.v2_0.compute.loaders.LoadFloatingIpsForInstance;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.strategy.ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIpForServer;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.FlavorInRegion;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ImageInRegion;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ServerInRegion;
import org.jclouds.util.Predicates2;

public class NovaComputeServiceContextModule
extends ComputeServiceAdapterContextModule<ServerInRegion, FlavorInRegion, ImageInRegion, Location> {
    @VisibleForTesting
    public static final Map<Server.Status, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put((Object)Server.Status.ACTIVE, (Object)NodeMetadata.Status.RUNNING).put((Object)Server.Status.BUILD, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.DELETED, (Object)NodeMetadata.Status.TERMINATED).put((Object)Server.Status.ERROR, (Object)NodeMetadata.Status.ERROR).put((Object)Server.Status.HARD_REBOOT, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.MIGRATING, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.PASSWORD, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.PAUSED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Server.Status.REBOOT, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.REBUILD, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.RESCUE, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.RESIZE, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.REVERT_RESIZE, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.SHELVED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Server.Status.SHELVED_OFFLOADED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Server.Status.SHUTOFF, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Server.Status.SOFT_DELETED, (Object)NodeMetadata.Status.TERMINATED).put((Object)Server.Status.STOPPED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Server.Status.SUSPENDED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Server.Status.UNKNOWN, (Object)NodeMetadata.Status.UNRECOGNIZED).put((Object)Server.Status.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).put((Object)Server.Status.VERIFY_RESIZE, (Object)NodeMetadata.Status.PENDING).build();
    @VisibleForTesting
    public static final Map<Image.Status, Image.Status> toPortableImageStatus = ImmutableMap.builder().put((Object)Image.Status.ACTIVE, (Object)Image.Status.AVAILABLE).put((Object)Image.Status.SAVING, (Object)Image.Status.PENDING).put((Object)Image.Status.DELETED, (Object)Image.Status.DELETED).put((Object)Image.Status.ERROR, (Object)Image.Status.ERROR).put((Object)Image.Status.UNKNOWN, (Object)Image.Status.UNRECOGNIZED).put((Object)Image.Status.UNRECOGNIZED, (Object)Image.Status.UNRECOGNIZED).build();

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<ServerInRegion, FlavorInRegion, ImageInRegion, Location>>(){}).to(NovaComputeServiceAdapter.class);
        this.bind(ComputeService.class).to(NovaComputeService.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ServerInRegion, NodeMetadata>>(){}).to(ServerInRegionToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<SecurityGroupInRegion, SecurityGroup>>(){}).to(NovaSecurityGroupInRegionToSecurityGroup.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Set<? extends NodeMetadata>, Multimap<String, String>>>(){}).to(OrphanedGroupsByRegionId.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ImageInRegion, Image>>(){}).to(ImageInRegionToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem>>(){}).to(ImageToOperatingSystem.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<FlavorInRegion, Hardware>>(){}).to(FlavorInRegionToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Location, Location>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind(TemplateOptions.class).to(NovaTemplateOptions.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<RegionAndId, Iterable<? extends FloatingIpForServer>>>(){}).annotatedWith((Annotation)Names.named((String)"FLOATINGIP")).to(LoadFloatingIpsForInstance.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<RegionSecurityGroupNameAndPorts, SecurityGroup>>(){}).to(CreateSecurityGroupIfNeeded.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<RegionAndName, SecurityGroup>>(){}).to(FindSecurityGroupOrCreate.class);
        this.bind(CreateNodesWithGroupEncodedIntoNameThenAddToSet.class).to(ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet.class);
        this.bind((TypeLiteral)new TypeLiteral<ImageExtension>(){}).to(NovaImageExtension.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<NodeMetadata, Boolean>>(){}).to(CleanupResources.class);
        this.install(new FactoryModuleBuilder().build(NeutronSecurityGroupToSecurityGroup.Factory.class));
        this.install(new FactoryModuleBuilder().build(NovaSecurityGroupToSecurityGroup.Factory.class));
        this.bind((TypeLiteral)new TypeLiteral<SecurityGroupExtension>(){}).toProvider(SecurityGroupExtensionProvider.class);
    }

    protected TemplateOptions provideTemplateOptions(Injector injector, TemplateOptions options) {
        return ((NovaTemplateOptions)options.as(NovaTemplateOptions.class)).autoAssignFloatingIp((Boolean)injector.getInstance(Key.get(Boolean.TYPE, (Annotation)Names.named((String)"jclouds.openstack-nova.auto-create-floating-ips")))).generateKeyPair((Boolean)injector.getInstance(Key.get(Boolean.TYPE, (Annotation)Names.named((String)"jclouds.openstack-nova.auto-generate-keypairs"))));
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-running")
    protected Predicate<RegionAndId> provideServerRunningPredicate(NovaApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ServerInStatusPredicate(api, Server.Status.ACTIVE), (long)timeouts.nodeRunning, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-terminated")
    protected Predicate<RegionAndId> provideServerTerminatedPredicate(NovaApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ServerTerminatedPredicate(api), (long)timeouts.nodeTerminated, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @javax.inject.Named(value="FLOATINGIP")
    protected final LoadingCache<RegionAndId, Iterable<? extends FloatingIpForServer>> instanceToFloatingIps(@javax.inject.Named(value="FLOATINGIP") CacheLoader<RegionAndId, Iterable<? extends FloatingIpForServer>> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    protected final LoadingCache<RegionAndName, SecurityGroup> securityGroupMap(CacheLoader<RegionAndName, SecurityGroup> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    protected Map<OsFamily, LoginCredentials> osFamilyToCredentials(Injector injector) {
        return ImmutableMap.of((Object)OsFamily.WINDOWS, (Object)LoginCredentials.builder().user("Administrator").build(), (Object)OsFamily.UBUNTU, (Object)LoginCredentials.builder().user("ubuntu").build());
    }

    @Provides
    @Singleton
    protected final Supplier<Map<String, Location>> createLocationIndexedById(@Memoized Supplier<Set<? extends Location>> locations) {
        return Suppliers.compose((Function)new Function<Set<? extends Location>, Map<String, Location>>(){

            public Map<String, Location> apply(Set<? extends Location> arg0) {
                Set<? extends Location> locations = arg0;
                return Maps.uniqueIndex(locations, (Function)new Function<Location, String>(){

                    public String apply(Location arg0) {
                        return arg0.getId();
                    }
                });
            }
        }, locations);
    }

    @Singleton
    @Provides
    protected final Map<Server.Status, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    protected final Map<Image.Status, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }

    @VisibleForTesting
    static class ServerTerminatedPredicate
    implements Predicate<RegionAndId> {
        private final NovaApi api;

        public ServerTerminatedPredicate(NovaApi api) {
            this.api = (NovaApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
        }

        public boolean apply(RegionAndId regionAndId) {
            Preconditions.checkNotNull((Object)regionAndId, (Object)"serverId");
            Server server = this.api.getServerApi(regionAndId.getRegion()).get(regionAndId.getId());
            return server == null;
        }
    }

    @VisibleForTesting
    static class ServerInStatusPredicate
    implements Predicate<RegionAndId> {
        private final NovaApi api;
        private final Server.Status status;

        public ServerInStatusPredicate(NovaApi api, Server.Status status) {
            this.api = (NovaApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
            this.status = (Server.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status must not be null"));
        }

        public boolean apply(RegionAndId regionAndId) {
            Preconditions.checkNotNull((Object)regionAndId, (Object)"serverId");
            Server server = this.api.getServerApi(regionAndId.getRegion()).get(regionAndId.getId());
            if (server == null) {
                throw new IllegalStateException(String.format("Server %s not found.", regionAndId.getId()));
            }
            return this.status.equals((Object)server.getStatus());
        }
    }

    @Singleton
    public static class SecurityGroupExtensionProvider
    implements Provider<SecurityGroupExtension> {
        @Inject(optional=true)
        @javax.inject.Named(value="openstack-neutron")
        protected Supplier<Context> neutronApiContextSupplier;
        private final NeutronSecurityGroupExtension neutronSecurityGroupExtension;
        private final NovaSecurityGroupExtension novaSecurityGroupExtension;

        @Inject
        SecurityGroupExtensionProvider(NeutronSecurityGroupExtension neutronSecurityGroupExtension, NovaSecurityGroupExtension novaSecurityGroupExtension) {
            this.neutronSecurityGroupExtension = neutronSecurityGroupExtension;
            this.novaSecurityGroupExtension = novaSecurityGroupExtension;
        }

        public SecurityGroupExtension get() {
            return this.neutronApiContextSupplier != null ? this.neutronSecurityGroupExtension : this.novaSecurityGroupExtension;
        }
    }
}

