/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.googlecloud.internal.NullSafeCopies;
import org.jclouds.googlecomputeengine.domain.AutoValue_Firewall;
import org.jclouds.googlecomputeengine.domain.AutoValue_Firewall_Rule;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Firewall {
    public abstract String id();

    public abstract URI selfLink();

    public abstract Date creationTimestamp();

    public abstract String name();

    @Nullable
    public abstract String description();

    public abstract URI network();

    public abstract List<String> sourceRanges();

    public abstract List<String> sourceTags();

    public abstract List<String> targetTags();

    public abstract List<Rule> allowed();

    @SerializedNames(value={"id", "selfLink", "creationTimestamp", "name", "description", "network", "sourceRanges", "sourceTags", "targetTags", "allowed"})
    public static Firewall create(String id, URI selfLink, Date creationTimestamp, String name, String description, URI network, List<String> sourceRanges, List<String> sourceTags, List<String> targetTags, List<Rule> allowed) {
        return new AutoValue_Firewall(id, selfLink, creationTimestamp, name, description, network, NullSafeCopies.copyOf(sourceRanges), NullSafeCopies.copyOf(sourceTags), NullSafeCopies.copyOf(targetTags), NullSafeCopies.copyOf(allowed));
    }

    Firewall() {
    }

    public static abstract class Rule {
        public abstract String ipProtocol();

        @Nullable
        public abstract List<String> ports();

        @SerializedNames(value={"IPProtocol", "ports"})
        public static Rule create(String ipProtocol, List<String> ports) {
            return new AutoValue_Firewall_Rule(ipProtocol, ports);
        }

        Rule() {
        }
    }
}

