/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSecurityException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.ChangeEvent;
import com.mongodb.connection.ChangeListener;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterableServer;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionFactory;
import com.mongodb.connection.ConnectionPool;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolExecutor;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerMonitor;
import com.mongodb.connection.ServerMonitorFactory;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class DefaultServer
implements ClusterableServer {
    private final ServerAddress serverAddress;
    private final ConnectionPool connectionPool;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ConnectionFactory connectionFactory;
    private final ServerMonitor serverMonitor;
    private final Set<ChangeListener<ServerDescription>> changeListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ChangeListener<ServerDescription> serverStateListener;
    private volatile ServerDescription description;
    private volatile boolean isClosed;

    public DefaultServer(ServerAddress serverAddress, ClusterConnectionMode clusterConnectionMode, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerMonitorFactory serverMonitorFactory) {
        Assertions.notNull("serverMonitorFactory", serverMonitorFactory);
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.connectionFactory = Assertions.notNull("connectionFactory", connectionFactory);
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
        this.connectionPool = Assertions.notNull("connectionPool", connectionPool);
        this.serverStateListener = new DefaultServerStateListener();
        this.description = ServerDescription.builder().state(ServerConnectionState.CONNECTING).address(serverAddress).build();
        this.serverMonitor = serverMonitorFactory.create(this.serverStateListener);
        this.serverMonitor.start();
    }

    @Override
    public Connection getConnection() {
        Assertions.isTrue("open", !this.isClosed());
        try {
            return this.connectionFactory.create(this.connectionPool.get(), new DefaultServerProtocolExecutor(), this.clusterConnectionMode);
        }
        catch (MongoSecurityException e) {
            this.invalidate();
            throw e;
        }
    }

    @Override
    public void getConnectionAsync(final SingleResultCallback<AsyncConnection> callback) {
        Assertions.isTrue("open", !this.isClosed());
        this.connectionPool.getAsync(new SingleResultCallback<InternalConnection>(){

            @Override
            public void onResult(InternalConnection result, Throwable t) {
                if (t instanceof MongoSecurityException) {
                    DefaultServer.this.invalidate();
                }
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(DefaultServer.this.connectionFactory.createAsync(result, new DefaultServerProtocolExecutor(), DefaultServer.this.clusterConnectionMode), null);
                }
            }
        });
    }

    @Override
    public ServerDescription getDescription() {
        Assertions.isTrue("open", !this.isClosed());
        return this.description;
    }

    @Override
    public void addChangeListener(ChangeListener<ServerDescription> changeListener) {
        Assertions.isTrue("open", !this.isClosed());
        this.changeListeners.add(changeListener);
    }

    @Override
    public void invalidate() {
        Assertions.isTrue("open", !this.isClosed());
        this.serverStateListener.stateChanged(new ChangeEvent<ServerDescription>(this.description, ServerDescription.builder().state(ServerConnectionState.CONNECTING).address(this.serverAddress).build()));
        this.connectionPool.invalidate();
        this.serverMonitor.invalidate();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.connectionPool.close();
            this.serverMonitor.close();
            this.isClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void connect() {
        this.serverMonitor.connect();
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    private void handleThrowable(Throwable t) {
        if (t instanceof MongoSocketException && !(t instanceof MongoSocketReadTimeoutException) || t instanceof MongoNotPrimaryException || t instanceof MongoNodeIsRecoveringException) {
            this.invalidate();
        }
    }

    private final class DefaultServerStateListener
    implements ChangeListener<ServerDescription> {
        private DefaultServerStateListener() {
        }

        @Override
        public void stateChanged(ChangeEvent<ServerDescription> event) {
            DefaultServer.this.description = event.getNewValue();
            for (ChangeListener listener : DefaultServer.this.changeListeners) {
                listener.stateChanged(event);
            }
        }
    }

    private class DefaultServerProtocolExecutor
    implements ProtocolExecutor {
        private DefaultServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(Protocol<T> protocol, InternalConnection connection) {
            try {
                return protocol.execute(connection);
            }
            catch (MongoException e) {
                DefaultServer.this.handleThrowable(e);
                throw e;
            }
        }

        @Override
        public <T> void executeAsync(Protocol<T> protocol, InternalConnection connection, final SingleResultCallback<T> callback) {
            protocol.executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback(new SingleResultCallback<T>(){

                @Override
                public void onResult(T result, Throwable t) {
                    if (t != null) {
                        DefaultServer.this.handleThrowable(t);
                    }
                    callback.onResult(result, t);
                }
            }));
        }
    }
}

