/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import javax.annotation.Nullable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.rest.domain.ApiError;
import org.apache.brooklyn.rest.transform.TaskTransformer;
import org.apache.brooklyn.rest.util.BrooklynRestResourceUtils;
import org.apache.brooklyn.rest.util.DefaultExceptionMapper;
import org.apache.brooklyn.rest.util.ManagementContextProvider;
import org.apache.brooklyn.rest.util.json.BrooklynJacksonJsonProvider;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.time.Duration;

public abstract class AbstractBrooklynRestResource {
    @Context
    protected UriInfo ui;
    @Context
    private ContextResolver<ManagementContext> mgmt;
    private BrooklynRestResourceUtils brooklynRestResourceUtils;
    private ObjectMapper mapper;

    public ManagementContext mgmt() {
        return (ManagementContext)Preconditions.checkNotNull((Object)this.mgmt.getContext(ManagementContext.class), (Object)"mgmt");
    }

    public ManagementContextInternal mgmtInternal() {
        return (ManagementContextInternal)this.mgmt();
    }

    protected synchronized Maybe<ManagementContext> mgmtMaybe() {
        return Maybe.of((Object)this.mgmt());
    }

    @VisibleForTesting
    public void setManagementContext(ManagementContext managementContext) {
        this.mgmt = new ManagementContextProvider(managementContext);
    }

    public synchronized BrooklynRestResourceUtils brooklyn() {
        if (this.brooklynRestResourceUtils != null) {
            return this.brooklynRestResourceUtils;
        }
        this.brooklynRestResourceUtils = new BrooklynRestResourceUtils(this.mgmt());
        return this.brooklynRestResourceUtils;
    }

    protected Response badRequest(Exception e) {
        DefaultExceptionMapper.logExceptionDetailsForDebugging(e);
        return ApiError.of((Throwable)e).asBadRequestResponseJson();
    }

    protected ObjectMapper mapper() {
        return this.mapper(this.mgmt());
    }

    protected ObjectMapper mapper(ManagementContext mgmt) {
        if (this.mapper == null) {
            this.mapper = BrooklynJacksonJsonProvider.findAnyObjectMapper(mgmt);
        }
        return this.mapper;
    }

    protected RestValueResolver resolving(Object v) {
        return this.resolving(v, this.mgmt());
    }

    protected RestValueResolver resolving(Object v, ManagementContext mgmt) {
        return RestValueResolver.resolving(mgmt, v).mapper(this.mapper(mgmt));
    }

    public static class RestValueResolver {
        private final Object valueToResolve;
        ManagementContext mgmt;
        @Nullable
        private ObjectMapper mapperN;
        private boolean preferJson;
        private boolean isJerseyReturnValue;
        @Nullable
        private Entity entity;
        @Nullable
        private Duration timeout;
        @Nullable
        private Object rendererHintSource;
        @Nullable
        private Boolean immediately;
        @Nullable
        private Boolean raw;
        @Nullable
        private Boolean useDisplayHints;
        @Nullable
        private Boolean skipResolution;
        @Nullable
        private Boolean suppressBecauseSecret;
        @Nullable
        private Boolean suppressSecrets;
        private boolean filterOutputFields = false;
        private static Object UNRESOLVED = "UNRESOLVED".toCharArray();

        public static RestValueResolver resolving(ManagementContext mgmt, Object v) {
            return new RestValueResolver(mgmt, v);
        }

        private RestValueResolver(ManagementContext mgmt, Object v) {
            this.mgmt = mgmt;
            this.valueToResolve = v;
        }

        public RestValueResolver mapper(ObjectMapper mapper) {
            this.mapperN = mapper;
            return this;
        }

        public RestValueResolver newInstanceResolving(Object v) {
            RestValueResolver result = RestValueResolver.resolving(this.mgmt, v);
            result.mapperN = this.mapperN;
            result.preferJson = this.preferJson;
            result.isJerseyReturnValue = this.isJerseyReturnValue;
            result.entity = this.entity;
            result.timeout = this.timeout;
            result.rendererHintSource = this.rendererHintSource;
            result.immediately = this.immediately;
            result.raw = this.raw;
            result.useDisplayHints = this.useDisplayHints;
            result.skipResolution = this.skipResolution;
            result.suppressBecauseSecret = this.suppressBecauseSecret;
            result.suppressSecrets = this.suppressSecrets;
            return result;
        }

        public ObjectMapper mapper() {
            if (this.mapperN == null) {
                this.mapperN = BrooklynJacksonJsonProvider.findAnyObjectMapper(this.mgmt);
            }
            return this.mapperN;
        }

        public RestValueResolver preferJson(boolean preferJson) {
            this.preferJson = preferJson;
            return this;
        }

        public RestValueResolver asJerseyOutermostReturnValue(boolean asJerseyReturnJson) {
            this.isJerseyReturnValue = asJerseyReturnJson;
            return this;
        }

        @Deprecated
        public RestValueResolver raw(Boolean raw) {
            this.raw = raw;
            return this;
        }

        public RestValueResolver useDisplayHints(Boolean useDisplayHints) {
            this.useDisplayHints = useDisplayHints;
            return this;
        }

        private boolean isUseDisplayHints() {
            if (this.raw != null && this.raw.booleanValue()) {
                return this.raw == false;
            }
            if (this.useDisplayHints != null) {
                return this.useDisplayHints;
            }
            return true;
        }

        public boolean isSuppressedBecauseSecret() {
            return Boolean.TRUE.equals(this.suppressBecauseSecret);
        }

        public RestValueResolver skipResolution(Boolean skipResolution) {
            this.skipResolution = skipResolution;
            return this;
        }

        public RestValueResolver suppressIfSecret(String keyName, Boolean suppressIfSecret) {
            this.suppressSecrets = suppressIfSecret;
            if (Boolean.TRUE.equals(suppressIfSecret)) {
                if (Sanitizer.IS_SECRET_PREDICATE.apply((Object)keyName)) {
                    this.suppressBecauseSecret = true;
                }
            } else {
                RestValueResolver.checkAndGetSecretsSuppressed(this.mgmt, suppressIfSecret, null);
            }
            return this;
        }

        public RestValueResolver context(Entity entity) {
            this.entity = entity;
            return this;
        }

        public RestValueResolver timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public RestValueResolver immediately(boolean immediately) {
            this.immediately = immediately;
            return this;
        }

        public RestValueResolver renderAs(Object rendererHintSource) {
            this.rendererHintSource = rendererHintSource;
            return this;
        }

        public RestValueResolver filterOutputFields(boolean filterOutputFields) {
            this.filterOutputFields = filterOutputFields;
            return this;
        }

        public Object resolve() {
            Object valueResult;
            Object object = valueResult = Boolean.TRUE.equals(this.skipResolution) ? this.valueToResolve : RestValueResolver.getImmediateValue(this.valueToResolve, this.entity, this.immediately, this.timeout);
            if (valueResult == UNRESOLVED) {
                valueResult = this.valueToResolve;
            }
            if (this.rendererHintSource != null && this.isUseDisplayHints()) {
                valueResult = RendererHints.applyDisplayValueHintUnchecked((Object)this.rendererHintSource, (Object)valueResult);
            }
            if (Boolean.TRUE.equals(this.suppressBecauseSecret)) {
                valueResult = RestValueResolver.suppressAsMinimalizedJson(this.mapper(), valueResult);
            }
            return RestValueResolver.getValueForDisplaySanitized(this.mgmt, this.mapper(), valueResult, this.preferJson, this.isJerseyReturnValue, Boolean.TRUE.equals(this.suppressSecrets) && !Boolean.TRUE.equals(this.suppressBecauseSecret), this.filterOutputFields);
        }

        private static Object getImmediateValue(Object value, @Nullable Entity context, @Nullable Boolean immediately, @Nullable Duration timeout) {
            return Tasks.resolving((Object)value).as(Object.class).defaultValue(UNRESOLVED).deep().timeout(timeout).immediately(immediately == null ? false : immediately).context(context).swallowExceptions().get();
        }

        public Object getValueForDisplay(Object value, Boolean preferJson, Boolean isJerseyReturnValue, Boolean suppressNestedSecrets) {
            return RestValueResolver.getValueForDisplay(this.mgmt, this.mapper(), value, preferJson != null ? preferJson : this.preferJson, isJerseyReturnValue != null ? isJerseyReturnValue : this.isJerseyReturnValue, suppressNestedSecrets != null ? suppressNestedSecrets : this.suppressSecrets, false);
        }

        public Object getValueForDisplay(Object value, Boolean preferJson, Boolean isJerseyReturnValue, Boolean suppressNestedSecrets, boolean filterOutputFields) {
            return RestValueResolver.getValueForDisplay(this.mgmt, this.mapper(), value, preferJson != null ? preferJson : this.preferJson, isJerseyReturnValue != null ? isJerseyReturnValue : this.isJerseyReturnValue, suppressNestedSecrets != null ? suppressNestedSecrets : this.suppressSecrets, filterOutputFields);
        }

        public static Object getValueForDisplay(ManagementContext mgmt, ObjectMapper mapper, Object value, boolean preferJson, boolean isJerseyReturnValue, Boolean suppressNestedSecrets, Boolean filterOutputFields) {
            suppressNestedSecrets = RestValueResolver.checkAndGetSecretsSuppressed(mgmt, suppressNestedSecrets, false);
            return RestValueResolver.getValueForDisplaySanitized(mgmt, mapper, value, preferJson, isJerseyReturnValue, suppressNestedSecrets, filterOutputFields);
        }

        static Object getValueForDisplaySanitized(ManagementContext mgmt, ObjectMapper mapper, Object value, boolean preferJson, boolean isJerseyReturnValue, Boolean suppressNestedSecrets, Boolean filterOutputFields) {
            if (suppressNestedSecrets == null) {
                suppressNestedSecrets = false;
            }
            if (filterOutputFields == null) {
                filterOutputFields = false;
            }
            if (preferJson) {
                if (value == null) {
                    return null;
                }
                Object result = value;
                result = value;
                if (result instanceof BrooklynDslDeferredSupplier) {
                    result = result.toString();
                }
                if (isJerseyReturnValue && result instanceof String) {
                    result = StringEscapes.JavaStringEscapes.wrapJavaString((String)((String)result));
                }
                if ((suppressNestedSecrets.booleanValue() || filterOutputFields.booleanValue()) && result != null && !Boxing.isPrimitiveOrBoxedObject((Object)result)) {
                    if (result instanceof CharSequence) {
                        if (suppressNestedSecrets.booleanValue()) {
                            result = Sanitizer.sanitizeMultilineString((String)result.toString());
                        }
                    } else {
                        try {
                            String resultS = mapper.writeValueAsString(result);
                            result = BeanWithTypeUtils.newSimpleMapper().readValue(resultS, Object.class);
                            if (filterOutputFields.booleanValue()) {
                                result = TaskTransformer.filterOutputFields(result);
                            }
                            if (suppressNestedSecrets.booleanValue()) {
                                result = Sanitizer.suppressNestedSecretsJson((Object)result, (boolean)true);
                            }
                        }
                        catch (JsonProcessingException e) {
                            throw Exceptions.propagateAnnotated((String)"Cannot serialize REST result", (Throwable)e);
                        }
                    }
                }
                return result;
            }
            if (value == null) {
                return "";
            }
            String resultS = value.toString();
            if (suppressNestedSecrets.booleanValue() && Sanitizer.IS_SECRET_PREDICATE.apply((Object)resultS)) {
                return RestValueResolver.suppressAsMinimalizedJson(mapper, value);
            }
            return resultS;
        }

        public static Boolean checkAndGetSecretsSuppressed(ManagementContext mgmt, Boolean suppressNestedSecrets, Boolean defaultValue) {
            if (Boolean.TRUE.equals(suppressNestedSecrets)) {
                return true;
            }
            boolean areSecretsAllowed = true;
            if (!areSecretsAllowed) {
                return true;
            }
            boolean isDefaultsSecretSAllowed = true;
            if (!isDefaultsSecretSAllowed) {
                return true;
            }
            if (suppressNestedSecrets == null) {
                return defaultValue;
            }
            return suppressNestedSecrets;
        }

        public static String suppressAsMinimalizedJson(ObjectMapper mapper, Object valueResult) {
            try {
                Object resultJ;
                if (valueResult == null) {
                    valueResult = "";
                }
                if (valueResult instanceof String) {
                    resultJ = valueResult;
                } else {
                    String resultS = mapper.writeValueAsString(valueResult);
                    resultJ = new Gson().fromJson(resultS, Object.class);
                }
                return Sanitizer.suppressJson((Object)resultJ, (boolean)true);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
    }
}

