/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.rest.api.ActivityApi;
import org.apache.brooklyn.rest.api.EntityApi;
import org.apache.brooklyn.rest.domain.LinkWithMetadata;
import org.apache.brooklyn.rest.domain.TaskSummary;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.resources.EntityResource;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.TaskInternal;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTransformer {
    private static final Logger log = LoggerFactory.getLogger(TaskTransformer.class);
    public static final Predicate<Object> IS_OUTPUT_FIELD = new IsOutputPredicate();
    static final Set<String> OUTPUT_VALUES = ImmutableSet.of((Object)"output", (Object)"stdout", (Object)"stderr", (Object)"headers", (Object)"content", (Object)"content_bytes", (Object[])new String[]{"content_json"});

    public static final Function<Task<?>, TaskSummary> fromTask(UriBuilder ub, AbstractBrooklynRestResource.RestValueResolver resolver, Boolean suppressSecrets) {
        return TaskTransformer.fromTask(ub, resolver, suppressSecrets, true);
    }

    public static final Function<Task<?>, TaskSummary> fromTask(final UriBuilder ub, final AbstractBrooklynRestResource.RestValueResolver resolver, final Boolean suppressSecrets, final boolean includeDetail) {
        return new Function<Task<?>, TaskSummary>(){

            @Override
            public TaskSummary apply(@Nullable Task<?> input) {
                return TaskTransformer.taskSummary(input, ub, resolver, suppressSecrets, includeDetail);
            }
        };
    }

    public static TaskSummary taskSummary(Task<?> task, UriBuilder ub, AbstractBrooklynRestResource.RestValueResolver resolver, Boolean suppressSecrets) {
        return TaskTransformer.taskSummary(task, ub, resolver, suppressSecrets, true);
    }

    public static TaskSummary taskSummary(Task<?> task, UriBuilder ub, AbstractBrooklynRestResource.RestValueResolver resolver, Boolean suppressSecrets, boolean includeDetail) {
        try {
            URI entityLink;
            String entityDisplayName;
            String entityId;
            Preconditions.checkNotNull(task);
            Entity entity = BrooklynTaskTags.getContextEntity(task);
            String selfLink = TaskTransformer.asLink(task, ub).getLink();
            if (entity != null) {
                entityId = entity.getId();
                entityDisplayName = entity.getDisplayName();
                String appId = entity.getApplicationId();
                entityLink = appId != null ? WebResourceUtils.serviceUriBuilder(ub, EntityApi.class, "get").build(new Object[]{appId, entityId}) : null;
            } else {
                entityId = null;
                entityDisplayName = null;
                entityLink = null;
            }
            List children = Collections.emptyList();
            if (task instanceof HasTaskChildren) {
                children = new ArrayList();
                for (Task t : ((HasTaskChildren)task).getChildren()) {
                    children.add(TaskTransformer.asLink(t, ub));
                }
            }
            MutableMap streams = new MutableMap();
            for (BrooklynTaskTags.WrappedStream stream : BrooklynTaskTags.streams(task)) {
                MutableMap metadata = MutableMap.of((Object)"name", (Object)stream.streamType);
                if (stream.streamSize.get() != null) {
                    metadata.add((Object)"size", stream.streamSize.get());
                    metadata.add((Object)"sizeText", (Object)Strings.makeSizeString((long)((Integer)stream.streamSize.get()).intValue()));
                }
                String link = selfLink + "/stream/" + StringEscapes.escapeHtmlFormUrl((String)stream.streamType).replaceAll("\\+", "%20");
                streams.put(stream.streamType, new LinkWithMetadata(link, (Map)metadata));
            }
            MutableMap links = MutableMap.of((Object)"self", (Object)new URI(selfLink), (Object)"children", (Object)new URI(selfLink + "/children"));
            if (entityLink != null) {
                links.put("entity", entityLink);
            }
            Collection tags = (Collection)resolver.getValueForDisplay(task.getTags(), true, false, suppressSecrets, !includeDetail);
            Object result = null;
            String detailedStatus = null;
            if (includeDetail) {
                try {
                    detailedStatus = (String)resolver.getValueForDisplay(task.getStatusDetail(true), true, false, suppressSecrets);
                    result = task.isDone() ? resolver.getValueForDisplay(task.get(), true, false, suppressSecrets) : null;
                }
                catch (Throwable t) {
                    result = Exceptions.collapseTextInContext((Throwable)t, (Object[])new Object[]{task});
                }
            }
            return new TaskSummary(task.getId(), task.getDisplayName(), task.getDescription(), entityId, entityDisplayName, tags, TaskTransformer.ifPositive(task.getSubmitTimeUtc()), TaskTransformer.ifPositive(task.getStartTimeUtc()), TaskTransformer.ifPositive(task.getEndTimeUtc()), task.getStatusSummary(), result, task.isError(), task.isCancelled(), children, TaskTransformer.asLink(task.getSubmittedByTask(), ub), task.isDone() ? null : (task instanceof TaskInternal ? TaskTransformer.asLink(((TaskInternal)task).getBlockingTask(), ub) : null), task.isDone() ? null : (task instanceof TaskInternal ? ((TaskInternal)task).getBlockingDetails() : null), detailedStatus, (Map)streams, (Map)links);
        }
        catch (URISyntaxException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static Long ifPositive(Long time) {
        if (time == null || time <= 0L) {
            return null;
        }
        return time;
    }

    public static LinkWithMetadata asLink(Task<?> t, UriBuilder ub) {
        Entity entity;
        if (t == null) {
            return null;
        }
        MutableMap data = new MutableMap();
        data.put((Object)"id", (Object)t.getId());
        if (t.getDisplayName() != null) {
            data.put((Object)"taskName", (Object)t.getDisplayName());
        }
        if ((entity = BrooklynTaskTags.getContextEntity(t)) != null) {
            data.put((Object)"entityId", (Object)entity.getId());
            if (entity.getDisplayName() != null) {
                data.put((Object)"entityDisplayName", (Object)entity.getDisplayName());
            }
        }
        URI taskUri = WebResourceUtils.serviceUriBuilder(ub, ActivityApi.class, "get").build(new Object[]{t.getId()});
        return new LinkWithMetadata(taskUri.toString(), (Map)data);
    }

    public static List<TaskSummary> fromTasks(List<Task<?>> tasksToScan, int limit, Boolean recurse, @Nullable Entity entity, UriInfo ui, AbstractBrooklynRestResource.RestValueResolver resolver, Boolean suppressSecrets) {
        return TaskTransformer.fromTasks(tasksToScan, limit, recurse, entity, ui, resolver, suppressSecrets, TaskSummaryMode.ALL);
    }

    public static List<TaskSummary> fromTasks(List<Task<?>> tasksToScan, int limit, Boolean recurse, @Nullable Entity entity, UriInfo ui, AbstractBrooklynRestResource.RestValueResolver resolver, Boolean suppressSecrets, TaskSummaryMode taskSummaryMode) {
        int sizeRemaining = limit;
        EntityResource.InterestingTasksFirstComparator comparator = new EntityResource.InterestingTasksFirstComparator(entity);
        if (limit > 0 && tasksToScan.size() > limit) {
            MutableMap mostRecentByName = MutableMap.of();
            MutableList otherTasks = MutableList.of();
            tasksToScan.forEach(arg_0 -> TaskTransformer.lambda$fromTasks$0((Map)mostRecentByName, comparator, (List)otherTasks, arg_0));
            if (mostRecentByName.size() <= limit) {
                tasksToScan = MutableList.copyOf(mostRecentByName.values());
                tasksToScan.addAll(Ordering.from((Comparator)comparator).leastOf((Iterable)otherTasks, limit - mostRecentByName.size()));
            } else {
                tasksToScan = MutableList.copyOf((Iterable)Ordering.from((Comparator)comparator).leastOf(mostRecentByName.values(), limit));
            }
        }
        tasksToScan = MutableList.copyOf((Iterable)Ordering.from((Comparator)comparator).sortedCopy(tasksToScan));
        MutableMap tasksLoaded = MutableMap.of();
        boolean isRecurse = Boolean.TRUE.equals(recurse);
        while (!tasksToScan.isEmpty()) {
            Task t = (Task)tasksToScan.remove(0);
            if (tasksLoaded.put(t.getId(), t) != null) continue;
            if (--sizeRemaining == 0) break;
            if (!isRecurse || !(t instanceof HasTaskChildren)) continue;
            Iterables.addAll((Collection)tasksToScan, (Iterable)((HasTaskChildren)t).getChildren());
        }
        ImmutableList finalTasksToScan = ImmutableList.copyOf((Collection)tasksToScan);
        return tasksLoaded.values().stream().map(arg_0 -> TaskTransformer.lambda$fromTasks$1(taskSummaryMode, isRecurse, (List)finalTasksToScan, ui, resolver, suppressSecrets, arg_0)).collect(Collectors.toList());
    }

    public static Object filterOutputFields(Object x) {
        if (x instanceof Map) {
            MutableMap y = MutableMap.of();
            ((Map)x).forEach((arg_0, arg_1) -> TaskTransformer.lambda$filterOutputFields$2((Map)y, arg_0, arg_1));
            return y;
        }
        if (x instanceof Iterable) {
            MutableList y = MutableList.of();
            ((Iterable)x).forEach(arg_0 -> TaskTransformer.lambda$filterOutputFields$3((List)y, arg_0));
            return y;
        }
        return x;
    }

    static Object filterOutputValue(Object v) {
        if (v == null || Boxing.isPrimitiveOrBoxedObject((Object)v)) {
            return v;
        }
        if (v instanceof CharSequence) {
            if (((CharSequence)v).length() < 80) {
                return v;
            }
            return "<filtered>";
        }
        return "<filtered (type " + v.getClass().getName() + ")>";
    }

    private static /* synthetic */ void lambda$filterOutputFields$3(List y, Object xi) {
        y.add(TaskTransformer.filterOutputFields(xi));
    }

    private static /* synthetic */ void lambda$filterOutputFields$2(Map y, Object k, Object v) {
        y.put(k, v != null && IS_OUTPUT_FIELD.apply(k) ? TaskTransformer.filterOutputValue(v) : TaskTransformer.filterOutputFields(v));
    }

    private static /* synthetic */ TaskSummary lambda$fromTasks$1(TaskSummaryMode taskSummaryMode, boolean isRecurse, List finalTasksToScan, UriInfo ui, AbstractBrooklynRestResource.RestValueResolver resolver, Boolean suppressSecrets, Task task) {
        boolean includeDetail = taskSummaryMode == TaskSummaryMode.ALL && !isRecurse || taskSummaryMode == TaskSummaryMode.SUBSET && finalTasksToScan.contains(task);
        Function<Task<?>, TaskSummary> taskTaskSummaryFunction = TaskTransformer.fromTask(ui.getBaseUriBuilder(), resolver, suppressSecrets, includeDetail);
        return taskTaskSummaryFunction.apply(task);
    }

    private static /* synthetic */ void lambda$fromTasks$0(Map mostRecentByName, EntityResource.InterestingTasksFirstComparator comparator, List otherTasks, Task t) {
        Task mostRecentOfSameName;
        String name = t.getDisplayName();
        if (name == null) {
            name = "";
        }
        if ((mostRecentOfSameName = mostRecentByName.put(name, t)) != null) {
            if (comparator.compare(mostRecentOfSameName, t) < 0) {
                mostRecentByName.put(name, mostRecentOfSameName);
                otherTasks.add(t);
            } else {
                otherTasks.add(mostRecentOfSameName);
            }
        }
    }

    private static class IsOutputPredicate
    implements Predicate<Object> {
        private IsOutputPredicate() {
        }

        public boolean apply(Object name) {
            if (name == null) {
                return false;
            }
            return OUTPUT_VALUES.contains(name.toString().toLowerCase());
        }
    }

    public static enum TaskSummaryMode {
        ALL,
        NONE,
        SUBSET;

    }
}

