/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.googlecloudstorage.domain.DomainResourceReferences;
import org.jclouds.googlecloudstorage.options.ListObjectOptions;

public class BlobStoreListContainerOptionsToListObjectOptions
implements Function<ListContainerOptions, ListObjectOptions> {
    public ListObjectOptions apply(ListContainerOptions from) {
        if (from.getDir() != null && (from.getPrefix() != null || from.getDelimiter() != null)) {
            throw new IllegalArgumentException("Cannot pass both directory and prefix/delimiter");
        }
        Preconditions.checkNotNull((Object)from, (Object)"set options to instance NONE instead of passing null");
        ListObjectOptions httpOptions = new ListObjectOptions();
        if (!from.isRecursive() && from.getDelimiter() == null) {
            httpOptions = httpOptions.delimiter("/");
        }
        if (from.getDelimiter() != null) {
            httpOptions = httpOptions.delimiter(from.getDelimiter());
        }
        if (from.getDir() != null) {
            String path = from.getDir();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            httpOptions = httpOptions.prefix(path);
        }
        if (from.getPrefix() != null) {
            httpOptions.prefix(from.getPrefix());
        }
        if (from.getMarker() != null) {
            httpOptions = httpOptions.pageToken(from.getMarker());
        }
        if (from.getMaxResults() != null) {
            httpOptions = httpOptions.maxResults(from.getMaxResults());
        }
        if (from.isDetailed()) {
            httpOptions = httpOptions.projection(DomainResourceReferences.Projection.FULL);
        }
        return httpOptions;
    }
}

