/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.handlers;

import com.google.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;

@Singleton
public final class GoogleCloudStorageClientErrorRetryHandler
implements HttpRetryHandler {
    private static final int TOO_MANY_REQUESTS = 429;
    private final BackoffLimitedRetryHandler backoffHandler;

    @Inject
    protected GoogleCloudStorageClientErrorRetryHandler(BackoffLimitedRetryHandler backoffHandler) {
        this.backoffHandler = backoffHandler;
    }

    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        if (response.getStatusCode() == 429) {
            return this.backoffHandler.shouldRetryRequest(command, response);
        }
        return false;
    }
}

