/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.api;

import com.google.common.annotations.Beta;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;

public interface JcloudsLocationConfigPublic
extends CloudLocationConfig {
    public static final ConfigKey<String> CLOUD_PROVIDER = LocationConfigKeys.CLOUD_PROVIDER;
    public static final ConfigKey<Boolean> RUN_AS_ROOT = ConfigKeys.newBooleanConfigKey((String)"runAsRoot", (String)"Whether to run initial setup as root (default true)", null);
    public static final ConfigKey<String> LOGIN_USER = ConfigKeys.newStringConfigKey((String)"loginUser", (String)"Override the user who logs in initially to perform setup (otherwise it is detected from the cloud or known defaults in cloud or VM OS)", null);
    public static final ConfigKey<String> LOGIN_USER_PASSWORD = ConfigKeys.newStringConfigKey((String)"loginUser.password", (String)"Custom password for the user who logs in initially", null);
    public static final ConfigKey<String> LOGIN_USER_PRIVATE_KEY_DATA = ConfigKeys.newStringConfigKey((String)"loginUser.privateKeyData", (String)"Custom private key for the user who logs in initially", null);
    public static final ConfigKey<String> LOGIN_USER_PRIVATE_KEY_FILE = ConfigKeys.newStringConfigKey((String)"loginUser.privateKeyFile", (String)"Custom private key for the user who logs in initially", null);
    public static final ConfigKey<String> EXTRA_PUBLIC_KEY_DATA_TO_AUTH = ConfigKeys.newStringConfigKey((String)"extraSshPublicKeyData", (String)"Additional public key data to add to authorized_keys (multi-line string supported, with one key per line)", null);
    public static final ConfigKey<List<String>> EXTRA_PUBLIC_KEY_URLS_TO_AUTH = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"extraSshPublicKeyUrls", (String)"Additional public keys (files or URLs, in SSH2/RFC4716/id_rsa.pub format) to add to authorized_keys", null);
    public static final ConfigKey<String> KEY_PAIR = ConfigKeys.newStringConfigKey((String)"keyPair", (String)("Custom keypair (name) known at the cloud to be installed on machines for initial login (selected clouds only); you may also need to set " + LOGIN_USER_PRIVATE_KEY_FILE.getName()), null);
    public static final ConfigKey<Boolean> AUTO_GENERATE_KEYPAIRS = ConfigKeys.newBooleanConfigKey((String)"jclouds.openstack-nova.auto-generate-keypairs", (String)"Whether to generate keypairs automatically (OpenStack Nova)");
    public static final ConfigKey<Boolean> AUTO_ASSIGN_FLOATING_IP = ConfigKeys.newBooleanConfigKey((String)"autoAssignFloatingIp", (String)"Whether to generate floating ips (in Nova paralance), or elastic IPs (in CloudStack parlance)");
    public static final ConfigKey<Boolean> DONT_CREATE_USER = ConfigKeys.newBooleanConfigKey((String)"dontCreateUser", (String)"Whether to skip creation of 'user' when provisioning machines (default false). Note that setting this will prevent jclouds from overwriting /etc/sudoers which might be configured incorrectly by default. See 'dontRequireTtyForSudo' for details.", (Boolean)false);
    public static final ConfigKey<Boolean> GRANT_USER_SUDO = ConfigKeys.newBooleanConfigKey((String)"grantUserSudo", (String)"Whether to grant the created user sudo privileges. Irrelevant if dontCreateUser is true. Default: true.", (Boolean)true);
    public static final ConfigKey<Boolean> DISABLE_ROOT_AND_PASSWORD_SSH = ConfigKeys.newBooleanConfigKey((String)"disableRootAndPasswordSsh", (String)"Whether to disable direct SSH access for root and disable password-based SSH, if creating a user with a key-based login; defaults to true (set false to leave root users alone)", (Boolean)true);
    public static final ConfigKey<String> CUSTOM_TEMPLATE_OPTIONS_SCRIPT_CONTENTS = ConfigKeys.newStringConfigKey((String)"customTemplateOptionsScriptContents", (String)"A custom script to pass to jclouds as part of template options, run after AdminAccess, for use primarily where a command which must run as root on first login before switching to the admin user, e.g. to customize sudoers; may start in an odd location (e.g. /tmp/bootstrap); NB: most commands should be run by entities, or if VM-specific but sudo is okay, then via setup.script, not via this");
    public static final ConfigKey<String> GROUP_ID = ConfigKeys.newStringConfigKey((String)"groupId", (String)"The Jclouds group provisioned machines should be members of. Users of this config key are also responsible for configuring security groups.");
    public static final ConfigKey<String> JCLOUDS_KEY_USERNAME = ConfigKeys.newStringConfigKey((String)"userName", (String)"Equivalent to 'user'; provided for jclouds compatibility", null);
    public static final ConfigKey<String> JCLOUDS_KEY_ENDPOINT = ConfigKeys.newStringConfigKey((String)"jclouds.endpoint", (String)"Equivalent to 'endpoint'; provided for jclouds compatibility", null);
    @Deprecated
    public static final ConfigKey<Boolean> OPEN_IPTABLES = ConfigKeys.newBooleanConfigKey((String)"openIptables", (String)"[DEPRECATED - use openIptables on SoftwareProcess entity] Whether to open the INBOUND_PORTS via iptables rules; if true then ssh in to run iptables commands, as part of machine provisioning", (Boolean)true);
    @Deprecated
    public static final ConfigKey<Boolean> STOP_IPTABLES = ConfigKeys.newBooleanConfigKey((String)"stopIptables", (String)"[DEPRECATED - use stopIptables on SoftwareProcess entity] Whether to stop iptables entirely; if true then ssh in to stop the iptables service, as part of machine provisioning", (Boolean)false);
    public static final ConfigKey<String> HARDWARE_ID = ConfigKeys.newStringConfigKey((String)"hardwareId", (String)"A system-specific identifier for the hardware profile or machine type to be used when creating a VM", null);
    public static final ConfigKey<String> IMAGE_ID = ConfigKeys.newStringConfigKey((String)"imageId", (String)"A system-specific identifier for the VM image to be used when creating a VM", null);
    public static final ConfigKey<String> IMAGE_NAME_REGEX = ConfigKeys.newStringConfigKey((String)"imageNameRegex", (String)"A regular expression to be compared against the 'name' when selecting the VM image to be used when creating a VM", null);
    public static final ConfigKey<String> IMAGE_DESCRIPTION_REGEX = ConfigKeys.newStringConfigKey((String)"imageDescriptionRegex", (String)"A regular expression to be compared against the 'description' when selecting the VM image to be used when creating a VM", null);
    public static final ConfigKey<String> TEMPLATE_SPEC = ConfigKeys.newStringConfigKey((String)"templateSpec", (String)"A jclouds 'spec' string consisting of properties and values to be used when creating a VM (in most cases the properties can, and should, be specified individually using other Brooklyn location config keys)", null);
    public static final ConfigKey<String> DEFAULT_IMAGE_ID = ConfigKeys.newStringConfigKey((String)"defaultImageId", (String)"A system-specific identifier for the VM image to be used by default when creating a VM (if no other VM image selection criteria are supplied)", null);
    public static final ConfigKey<Object> SECURITY_GROUPS = new BasicConfigKey(Object.class, "securityGroups", "Security groups to be applied when creating a VM, on supported clouds (either a single group identifier as a String, or an Iterable<String> or String[])", null);
    public static final ConfigKey<String> USER_METADATA_STRING = ConfigKeys.newStringConfigKey((String)"userMetadataString", (String)"Arbitrary user data, as a single string, on supported clouds (AWS)", null);
    public static final ConfigKey<Object> STRING_TAGS = new BasicConfigKey(Object.class, "tags", "Tags to be applied when creating a VM, on supported clouds (either a single tag as a String, or an Iterable<String> or String[];note this is not key-value pairs (e.g. what AWS calls 'tags'), for that see userMetadata)", null);
    public static final ConfigKey<Object> USER_METADATA_MAP = new BasicConfigKey(Object.class, "userMetadata", "Arbitrary user metadata, as a map (or String of comma-separated key=value pairs), on supported clouds; note often values cannot be null", null);
    public static final ConfigKey<Boolean> INCLUDE_BROOKLYN_USER_METADATA = ConfigKeys.newBooleanConfigKey((String)"includeBrooklynUserMetadata", (String)"Whether to set metadata about the context of a machine, e.g. brooklyn-entity-id, brooklyn-app-name (default true)", (Boolean)true);
    public static final ConfigKey<Boolean> DONT_REQUIRE_TTY_FOR_SUDO = ConfigKeys.newBooleanConfigKey((String)"dontRequireTtyForSudo", (String)"Whether to explicitly set /etc/sudoers, so don't need tty (will leave unchanged if 'false'); some machines require a tty for sudo; brooklyn by default does not use a tty (so that it can get separate error+stdout streams); you can enable a tty as an option to every ssh command, or you can do it once and modify the machine so that a tty is not subsequently required. Usually used in conjunction with 'dontCreateUser' since it will prevent jclouds from overwriting /etc/sudoers and overriding the system default. When not explicitly set will be applied if 'dontCreateUser' is set.");
    public static final ConfigKey<Boolean> MAP_DEV_RANDOM_TO_DEV_URANDOM = ConfigKeys.newBooleanConfigKey((String)"installDevUrandom", (String)"Map /dev/random to /dev/urandom to prevent halting on insufficient entropy", (Boolean)true);
    public static final ConfigKey<String> LOCAL_TEMP_DIR = SshTool.PROP_LOCAL_TEMP_DIR;
    public static final ConfigKey<Integer> OVERRIDE_RAM = ConfigKeys.newIntegerConfigKey((String)"overrideRam", (String)"Custom ram value");
    public static final ConfigKey<String> NETWORK_NAME = ConfigKeys.newStringConfigKey((String)"networkName", (String)"Network name or ID where the instance should be created (e.g. the subnet ID in AWS");
    public static final ConfigKey<String> CUSTOM_MACHINE_SETUP_SCRIPT_URL = ConfigKeys.newStringConfigKey((String)"setup.script", (String)"Custom script to customize a node");
    public static final ConfigKey<List<String>> CUSTOM_MACHINE_SETUP_SCRIPT_URL_LIST = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"setup.scripts", (String)"A list of scripts to customize a node");
    public static final ConfigKey<String> CUSTOM_MACHINE_SETUP_SCRIPT_VARS = ConfigKeys.newStringConfigKey((String)"setup.script.vars", (String)"vars to customize a setup.script i.e.: key1:value1,key2:value2");
    public static final ConfigKey<Boolean> GENERATE_HOSTNAME = ConfigKeys.newBooleanConfigKey((String)"generate.hostname", (String)"Use the nodename generated by jclouds", (Boolean)false);
    public static final ConfigKey<Boolean> USE_PORT_FORWARDING = ConfigKeys.newBooleanConfigKey((String)"portforwarding.enabled", (String)"Whether to setup port-forwarding to subsequently access the VM (over the ssh port)", (Boolean)false);
    @Beta
    public static final ConfigKey<Boolean> USE_JCLOUDS_SSH_INIT = ConfigKeys.newBooleanConfigKey((String)"useJcloudsSshInit", (String)"Whether to use jclouds for initial ssh-based setup (i.e. as part of the 'TemplateOptions'); if false will use core brooklyn ssh utilities. This config is beta; its default could be changed and/or the option removed in an upcoming release.", (Boolean)true);
    @Beta
    public static final ConfigKey<Boolean> LOOKUP_AWS_HOSTNAME = ConfigKeys.newBooleanConfigKey((String)"lookupAwsHostname", (String)"Whether to lookup the AWS hostname (via a command on the VM), or to just use the IP.", (Boolean)true);
    public static final ConfigKey<PortForwardManager> PORT_FORWARDING_MANAGER = BrooklynAccessUtils.PORT_FORWARDING_MANAGER;
    public static final ConfigKey<Integer> MACHINE_CREATE_ATTEMPTS = ConfigKeys.newIntegerConfigKey((String)"machineCreateAttempts", (String)"Number of times to retry if jclouds fails to create a VM", (Integer)2);
    public static final ConfigKey<Integer> MAX_CONCURRENT_MACHINE_CREATIONS = ConfigKeys.newIntegerConfigKey((String)"maxConcurrentMachineCreations", (String)"Maximum number of concurrent machine-creations", (Integer)Integer.MAX_VALUE);
    public static final ConfigKey<Integer> MAX_CONCURRENT_MACHINE_DELETIONS = ConfigKeys.newIntegerConfigKey((String)"maxConcurrentMachineDeletions", (String)"Maximum number of concurrent machine-deletions", (Integer)Integer.MAX_VALUE);
    public static final ConfigKey<Semaphore> MACHINE_CREATION_SEMAPHORE = ConfigKeys.newConfigKey(Semaphore.class, (String)"machineCreationSemaphore", (String)"Semaphore for controlling concurrent machine creation", null);
    public static final ConfigKey<Semaphore> MACHINE_DELETION_SEMAPHORE = ConfigKeys.newConfigKey(Semaphore.class, (String)"machineDeletionSemaphore", (String)"Semaphore for controlling concurrent machine deletion", null);
    public static final ConfigKey<Map<String, Object>> TEMPLATE_OPTIONS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, Object>>(){}, (String)"templateOptions", (String)"Additional jclouds template options");
    @Beta
    public static final ConfigKey<Boolean> USE_MACHINE_PUBLIC_ADDRESS_AS_PRIVATE_ADDRESS = ConfigKeys.newBooleanConfigKey((String)"useMachinePublicAddressAsPrivateAddress", (String)"When true we will use the public IP/Hostname of a JClouds Location as the private IP/Hostname", (Boolean)false);
}

